/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.utils;

import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.builder.api.Component;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;

public class LogUtil {
    public static String getLogPath() throws NoSuchFieldException, IllegalAccessException {
        String routingAppender = "routingAppender";
        String fileAppender = "fileAppender";
        PropertiesConfiguration config = LogUtil.getLogConfiguration();
        String routingLogFilePath = LogUtil.getRoutingLogFilePath(config);
        String fileLogPath = LogUtil.getFileLogPath(config);
        String logRef = config.getLoggerConfig("").getAppenderRefs().stream().map(Object::toString).filter(ref -> ref.contains(routingAppender) || ref.contains(fileAppender)).findFirst().orElse("");
        if (logRef.equals(routingAppender)) {
            return routingLogFilePath.substring(0, routingLogFilePath.lastIndexOf("/"));
        }
        if (logRef.equals(fileAppender)) {
            return fileLogPath.substring(0, routingLogFilePath.lastIndexOf("/"));
        }
        throw new IllegalArgumentException(String.format("Log file path is empty, get logRef : %s", logRef));
    }

    private static PropertiesConfiguration getLogConfiguration() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        return (PropertiesConfiguration)context.getConfiguration();
    }

    private static String getRoutingLogFilePath(PropertiesConfiguration config) throws NoSuchFieldException, IllegalAccessException {
        Field propertiesField = BuiltConfiguration.class.getDeclaredField("appendersComponent");
        propertiesField.setAccessible(true);
        Component propertiesComponent = (Component)propertiesField.get(config);
        StrSubstitutor substitutor = config.getStrSubstitutor();
        return propertiesComponent.getComponents().stream().filter(component -> "routingAppender".equals(component.getAttributes().get("name"))).flatMap(component -> component.getComponents().stream()).flatMap(component -> component.getComponents().stream()).flatMap(component -> component.getComponents().stream()).map(component -> substitutor.replace((String)component.getAttributes().get("fileName"))).findFirst().orElse(null);
    }

    private static String getFileLogPath(PropertiesConfiguration config) throws NoSuchFieldException, IllegalAccessException {
        Field propertiesField = BuiltConfiguration.class.getDeclaredField("appendersComponent");
        propertiesField.setAccessible(true);
        Component propertiesComponent = (Component)propertiesField.get(config);
        StrSubstitutor substitutor = config.getStrSubstitutor();
        return propertiesComponent.getComponents().stream().filter(component -> "fileAppender".equals(component.getAttributes().get("name"))).map(component -> substitutor.replace((String)component.getAttributes().get("fileName"))).findFirst().orElse(null);
    }
}

