/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.utils.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class CompletableFuture<T>
extends java.util.concurrent.CompletableFuture<T> {
    public static final Executor EXECUTOR = new ThreadPoolExecutor(Math.min(8, Runtime.getRuntime().availableProcessors()), Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
        private final AtomicInteger seq = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "SeaTunnel-CompletableFuture-Thread-" + this.seq.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });

    public CompletableFuture() {
    }

    public CompletableFuture(java.util.concurrent.CompletableFuture<T> future) {
        future.whenComplete((T value, U ex) -> {
            if (ex != null) {
                super.completeExceptionally((Throwable)ex);
            } else {
                super.complete(value);
            }
        });
    }

    public static CompletableFuture<Void> allOf(CompletableFuture<?> ... cfs) {
        return new CompletableFuture<Void>(java.util.concurrent.CompletableFuture.allOf(cfs));
    }

    public static CompletableFuture<Void> allOf(java.util.concurrent.CompletableFuture<?> ... cfs) {
        return new CompletableFuture<Void>(java.util.concurrent.CompletableFuture.allOf(cfs));
    }

    @Override
    public boolean complete(T value) {
        return super.complete(value);
    }

    public static <U> CompletableFuture<U> completedFuture(U value) {
        return new CompletableFuture<U>(java.util.concurrent.CompletableFuture.completedFuture(value));
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        return new CompletableFuture<Void>(java.util.concurrent.CompletableFuture.runAsync(runnable, EXECUTOR));
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable, Executor executor) {
        return new CompletableFuture<Void>(java.util.concurrent.CompletableFuture.runAsync(runnable, executor));
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return new CompletableFuture<T>(super.exceptionally((Function)fn));
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return new CompletableFuture<T>(super.whenComplete((BiConsumer)action));
    }

    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return new CompletableFuture<Void>((java.util.concurrent.CompletableFuture<Void>)super.thenAccept((Consumer)action));
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        return new CompletableFuture<U>(java.util.concurrent.CompletableFuture.supplyAsync(supplier, EXECUTOR));
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        return new CompletableFuture<U>(java.util.concurrent.CompletableFuture.supplyAsync(supplier, executor));
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return new CompletableFuture<T>(super.thenApply((Function)fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return new CompletableFuture<T>(super.thenApplyAsync((Function)fn, EXECUTOR));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return new CompletableFuture<T>(super.thenApplyAsync((Function)fn, executor));
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return new CompletableFuture<T>(super.whenCompleteAsync((BiConsumer)action, EXECUTOR));
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return new CompletableFuture<T>(super.whenCompleteAsync((BiConsumer)action, executor));
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        return super.completeExceptionally(ex);
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return super.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return super.get(timeout, unit);
    }

    @Override
    public T join() {
        return super.join();
    }

    @Override
    public void obtrudeException(Throwable ex) {
        super.obtrudeException(ex);
    }

    @Override
    public void obtrudeValue(T value) {
        super.obtrudeValue(value);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return super.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return super.isCancelled();
    }

    @Override
    public boolean isDone() {
        return super.isDone();
    }
}

