/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.config.server;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.seatunnel.engine.common.config.server.CheckpointStorageConfig;
import org.apache.seatunnel.engine.common.config.server.ServerConfigOptions;

public class CheckpointConfig
implements Serializable {
    public static final long MINIMAL_CHECKPOINT_TIME = 10L;
    private long checkpointInterval = ((Integer)ServerConfigOptions.CHECKPOINT_INTERVAL.defaultValue()).intValue();
    private long checkpointTimeout = ((Integer)ServerConfigOptions.CHECKPOINT_TIMEOUT.defaultValue()).intValue();
    private int maxConcurrentCheckpoints = (Integer)ServerConfigOptions.CHECKPOINT_MAX_CONCURRENT.defaultValue();
    private int tolerableFailureCheckpoints = (Integer)ServerConfigOptions.CHECKPOINT_TOLERABLE_FAILURE.defaultValue();
    private CheckpointStorageConfig storage = (CheckpointStorageConfig)ServerConfigOptions.CHECKPOINT_STORAGE.defaultValue();

    public void setCheckpointInterval(long checkpointInterval) {
        Preconditions.checkArgument((checkpointInterval >= 10L ? 1 : 0) != 0, (Object)"The minimum checkpoint interval is 10 mills.");
        this.checkpointInterval = checkpointInterval;
    }

    public void setCheckpointTimeout(long checkpointTimeout) {
        Preconditions.checkArgument((checkpointTimeout >= 10L ? 1 : 0) != 0, (Object)"The minimum checkpoint timeout is 10 mills.");
        this.checkpointTimeout = checkpointTimeout;
    }

    public void setMaxConcurrentCheckpoints(int maxConcurrentCheckpoints) {
        Preconditions.checkArgument((maxConcurrentCheckpoints >= 1 ? 1 : 0) != 0, (Object)"The minimum number of concurrent checkpoints is 1.");
        this.maxConcurrentCheckpoints = maxConcurrentCheckpoints;
    }

    public void setTolerableFailureCheckpoints(int tolerableFailureCheckpoints) {
        Preconditions.checkArgument((this.maxConcurrentCheckpoints >= 0 ? 1 : 0) != 0, (Object)"The number of tolerance failed checkpoints must be a natural number.");
        this.tolerableFailureCheckpoints = tolerableFailureCheckpoints;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public long getCheckpointTimeout() {
        return this.checkpointTimeout;
    }

    public int getMaxConcurrentCheckpoints() {
        return this.maxConcurrentCheckpoints;
    }

    public int getTolerableFailureCheckpoints() {
        return this.tolerableFailureCheckpoints;
    }

    public CheckpointStorageConfig getStorage() {
        return this.storage;
    }

    public void setStorage(CheckpointStorageConfig storage) {
        this.storage = storage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckpointConfig)) {
            return false;
        }
        CheckpointConfig other = (CheckpointConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCheckpointInterval() != other.getCheckpointInterval()) {
            return false;
        }
        if (this.getCheckpointTimeout() != other.getCheckpointTimeout()) {
            return false;
        }
        if (this.getMaxConcurrentCheckpoints() != other.getMaxConcurrentCheckpoints()) {
            return false;
        }
        if (this.getTolerableFailureCheckpoints() != other.getTolerableFailureCheckpoints()) {
            return false;
        }
        CheckpointStorageConfig this$storage = this.getStorage();
        CheckpointStorageConfig other$storage = other.getStorage();
        return !(this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CheckpointConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $checkpointInterval = this.getCheckpointInterval();
        result = result * 59 + (int)($checkpointInterval >>> 32 ^ $checkpointInterval);
        long $checkpointTimeout = this.getCheckpointTimeout();
        result = result * 59 + (int)($checkpointTimeout >>> 32 ^ $checkpointTimeout);
        result = result * 59 + this.getMaxConcurrentCheckpoints();
        result = result * 59 + this.getTolerableFailureCheckpoints();
        CheckpointStorageConfig $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        return result;
    }

    public String toString() {
        return "CheckpointConfig(checkpointInterval=" + this.getCheckpointInterval() + ", checkpointTimeout=" + this.getCheckpointTimeout() + ", maxConcurrentCheckpoints=" + this.getMaxConcurrentCheckpoints() + ", tolerableFailureCheckpoints=" + this.getTolerableFailureCheckpoints() + ", storage=" + this.getStorage() + ")";
    }
}

