/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.YamlClientConfigBuilder;
import com.hazelcast.client.config.impl.YamlClientConfigLocator;
import com.hazelcast.config.Config;
import com.hazelcast.config.YamlConfigBuilder;
import com.hazelcast.internal.config.DeclarativeConfigUtil;
import com.hazelcast.internal.config.YamlConfigLocator;
import com.hazelcast.internal.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.util.Properties;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.common.config.YamlSeaTunnelConfigBuilder;
import org.apache.seatunnel.engine.common.config.YamlSeaTunnelConfigLocator;

public final class ConfigProvider {
    private ConfigProvider() {
    }

    public static SeaTunnelConfig locateAndGetSeaTunnelConfig() {
        return ConfigProvider.locateAndGetSeaTunnelConfig(null);
    }

    @NonNull
    public static SeaTunnelConfig locateAndGetSeaTunnelConfig(Properties properties) {
        SeaTunnelConfig config;
        YamlSeaTunnelConfigLocator yamlConfigLocator = new YamlSeaTunnelConfigLocator();
        if (yamlConfigLocator.locateFromSystemProperty()) {
            config = new YamlSeaTunnelConfigBuilder(yamlConfigLocator).setProperties(properties).build();
        } else if (yamlConfigLocator.locateInWorkDirOrOnClasspath()) {
            config = new YamlSeaTunnelConfigBuilder(yamlConfigLocator).setProperties(properties).build();
        } else {
            yamlConfigLocator.locateDefault();
            config = new YamlSeaTunnelConfigBuilder(yamlConfigLocator).setProperties(properties).build();
        }
        return config;
    }

    public static SeaTunnelConfig locateAndGetSeaTunnelConfigFromString(String source) {
        return ConfigProvider.locateAndGetSeaTunnelConfigFromString(source, null);
    }

    @NonNull
    public static SeaTunnelConfig locateAndGetSeaTunnelConfigFromString(String source, Properties properties) {
        if (StringUtil.isNullOrEmptyAfterTrim((String)source)) {
            throw new IllegalArgumentException("provided string configuration is null or empty! Please use a well-structured content.");
        }
        byte[] bytes = source.getBytes();
        SeaTunnelConfig config = new YamlSeaTunnelConfigBuilder(new ByteArrayInputStream(bytes)).setProperties(properties).build();
        return config;
    }

    @NonNull
    public static ClientConfig locateAndGetClientConfig() {
        ClientConfig config;
        DeclarativeConfigUtil.validateSuffixInSystemProperty((String)"hazelcast.client.config");
        YamlClientConfigLocator yamlConfigLocator = new YamlClientConfigLocator();
        if (yamlConfigLocator.locateFromSystemProperty()) {
            config = new YamlClientConfigBuilder(yamlConfigLocator.getIn()).build();
        } else if (yamlConfigLocator.locateInWorkDirOrOnClasspath()) {
            config = new YamlClientConfigBuilder(yamlConfigLocator.getIn()).build();
        } else {
            yamlConfigLocator.locateDefault();
            config = new YamlClientConfigBuilder(yamlConfigLocator.getIn()).build();
        }
        return config;
    }

    @NonNull
    public static Config locateAndGetMemberConfig(Properties properties) {
        Config config;
        DeclarativeConfigUtil.validateSuffixInSystemProperty((String)"hazelcast.config");
        YamlConfigLocator yamlConfigLocator = new YamlConfigLocator();
        if (yamlConfigLocator.locateFromSystemProperty()) {
            config = new YamlConfigBuilder(yamlConfigLocator.getIn()).setProperties(properties).build();
        } else if (yamlConfigLocator.locateInWorkDirOrOnClasspath()) {
            config = new YamlConfigBuilder(yamlConfigLocator.getIn()).setProperties(properties).build();
        } else {
            yamlConfigLocator.locateDefault();
            config = new YamlConfigBuilder(yamlConfigLocator.getIn()).setProperties(properties).build();
        }
        return config;
    }
}

