/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.config;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.config.AbstractDomConfigProcessor;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.engine.common.config.EngineConfig;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfigSections;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.common.config.server.CheckpointStorageConfig;
import org.apache.seatunnel.engine.common.config.server.ConnectorJarHAStorageConfig;
import org.apache.seatunnel.engine.common.config.server.ConnectorJarStorageConfig;
import org.apache.seatunnel.engine.common.config.server.ConnectorJarStorageMode;
import org.apache.seatunnel.engine.common.config.server.QueueType;
import org.apache.seatunnel.engine.common.config.server.ServerConfigOptions;
import org.apache.seatunnel.engine.common.config.server.SlotServiceConfig;
import org.apache.seatunnel.engine.common.config.server.ThreadShareMode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class YamlSeaTunnelDomConfigProcessor
extends AbstractDomConfigProcessor {
    private static final ILogger LOGGER = Logger.getLogger(YamlSeaTunnelDomConfigProcessor.class);
    private final SeaTunnelConfig config;

    YamlSeaTunnelDomConfigProcessor(boolean domLevel3, SeaTunnelConfig config) {
        super(domLevel3);
        this.config = config;
    }

    public void buildConfig(Node rootNode) {
        for (Node node : DomConfigHelper.childElements((Node)rootNode)) {
            String nodeName = DomConfigHelper.cleanNodeName((Node)node);
            if (this.occurrenceSet.contains(nodeName)) {
                throw new InvalidConfigurationException("Duplicate '" + nodeName + "' definition found in the configuration.");
            }
            if (this.handleNode(node, nodeName) || SeaTunnelConfigSections.canOccurMultipleTimes(nodeName)) continue;
            this.occurrenceSet.add(nodeName);
        }
    }

    private boolean handleNode(Node node, String name) {
        if (!SeaTunnelConfigSections.ENGINE.isEqual(name)) {
            return true;
        }
        this.parseEngineConfig(node, this.config);
        return false;
    }

    private SlotServiceConfig parseSlotServiceConfig(Node slotServiceNode) {
        SlotServiceConfig slotServiceConfig = new SlotServiceConfig();
        for (Node node : DomConfigHelper.childElements((Node)slotServiceNode)) {
            String name = DomConfigHelper.cleanNodeName((Node)node);
            if (ServerConfigOptions.DYNAMIC_SLOT.key().equals(name)) {
                slotServiceConfig.setDynamicSlot(DomConfigHelper.getBooleanValue((String)this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.SLOT_NUM.key().equals(name)) {
                slotServiceConfig.setSlotNum(DomConfigHelper.getIntegerValue((String)ServerConfigOptions.SLOT_NUM.key(), (String)this.getTextContent(node)));
                continue;
            }
            LOGGER.warning("Unrecognized element: " + name);
        }
        return slotServiceConfig;
    }

    private void parseEngineConfig(Node engineNode, SeaTunnelConfig config) {
        EngineConfig engineConfig = config.getEngineConfig();
        for (Node node : DomConfigHelper.childElements((Node)engineNode)) {
            String name = DomConfigHelper.cleanNodeName((Node)node);
            if (ServerConfigOptions.BACKUP_COUNT.key().equals(name)) {
                engineConfig.setBackupCount(DomConfigHelper.getIntegerValue((String)ServerConfigOptions.BACKUP_COUNT.key(), (String)this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.QUEUE_TYPE.key().equals(name)) {
                engineConfig.setQueueType(QueueType.valueOf(this.getTextContent(node).toUpperCase(Locale.ROOT)));
                continue;
            }
            if (ServerConfigOptions.PRINT_EXECUTION_INFO_INTERVAL.key().equals(name)) {
                engineConfig.setPrintExecutionInfoInterval(DomConfigHelper.getIntegerValue((String)ServerConfigOptions.PRINT_EXECUTION_INFO_INTERVAL.key(), (String)this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.PRINT_JOB_METRICS_INFO_INTERVAL.key().equals(name)) {
                engineConfig.setPrintJobMetricsInfoInterval(DomConfigHelper.getIntegerValue((String)ServerConfigOptions.PRINT_JOB_METRICS_INFO_INTERVAL.key(), (String)this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.JOB_METRICS_BACKUP_INTERVAL.key().equals(name)) {
                engineConfig.setJobMetricsBackupInterval(DomConfigHelper.getIntegerValue((String)ServerConfigOptions.JOB_METRICS_BACKUP_INTERVAL.key(), (String)this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.TASK_EXECUTION_THREAD_SHARE_MODE.key().equals(name)) {
                String mode = this.getTextContent(node).toUpperCase(Locale.ROOT);
                if (!Arrays.asList("ALL", "OFF", "PART").contains(mode)) {
                    throw new IllegalArgumentException(ServerConfigOptions.TASK_EXECUTION_THREAD_SHARE_MODE + " must in [ALL, OFF, PART]");
                }
                engineConfig.setTaskExecutionThreadShareMode(ThreadShareMode.valueOf(mode));
                continue;
            }
            if (ServerConfigOptions.SLOT_SERVICE.key().equals(name)) {
                engineConfig.setSlotServiceConfig(this.parseSlotServiceConfig(node));
                continue;
            }
            if (ServerConfigOptions.CHECKPOINT.key().equals(name)) {
                engineConfig.setCheckpointConfig(this.parseCheckpointConfig(node));
                continue;
            }
            if (ServerConfigOptions.HISTORY_JOB_EXPIRE_MINUTES.key().equals(name)) {
                engineConfig.setHistoryJobExpireMinutes(DomConfigHelper.getIntegerValue((String)ServerConfigOptions.HISTORY_JOB_EXPIRE_MINUTES.key(), (String)this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.CONNECTOR_JAR_STORAGE_CONFIG.key().equals(name)) {
                engineConfig.setConnectorJarStorageConfig(this.parseConnectorJarStorageConfig(node));
                continue;
            }
            if (ServerConfigOptions.CLASSLOADER_CACHE_MODE.key().equals(name)) {
                engineConfig.setClassloaderCacheMode(DomConfigHelper.getBooleanValue((String)this.getTextContent(node)));
                continue;
            }
            if ("event-report-http".equalsIgnoreCase(name)) {
                NamedNodeMap attributes = node.getAttributes();
                Node urlNode = attributes.getNamedItem("url");
                if (urlNode == null) continue;
                engineConfig.setEventReportHttpApi(this.getTextContent(urlNode));
                Node headersNode = attributes.getNamedItem("headers");
                if (headersNode == null) continue;
                LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
                NodeList nodeList = headersNode.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node item = nodeList.item(i);
                    headers.put(DomConfigHelper.cleanNodeName((Node)item), this.getTextContent(item));
                }
                engineConfig.setEventReportHttpHeaders(headers);
                continue;
            }
            LOGGER.warning("Unrecognized element: " + name);
        }
    }

    private CheckpointConfig parseCheckpointConfig(Node checkpointNode) {
        CheckpointConfig checkpointConfig = new CheckpointConfig();
        for (Node node : DomConfigHelper.childElements((Node)checkpointNode)) {
            String name = DomConfigHelper.cleanNodeName((Node)node);
            if (ServerConfigOptions.CHECKPOINT_INTERVAL.key().equals(name)) {
                checkpointConfig.setCheckpointInterval(DomConfigHelper.getIntegerValue((String)ServerConfigOptions.CHECKPOINT_INTERVAL.key(), (String)this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.CHECKPOINT_TIMEOUT.key().equals(name)) {
                checkpointConfig.setCheckpointTimeout(DomConfigHelper.getIntegerValue((String)ServerConfigOptions.CHECKPOINT_TIMEOUT.key(), (String)this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.SCHEMA_CHANGE_CHECKPOINT_TIMEOUT.key().equals(name)) {
                checkpointConfig.setSchemaChangeCheckpointTimeout(DomConfigHelper.getIntegerValue((String)ServerConfigOptions.SCHEMA_CHANGE_CHECKPOINT_TIMEOUT.key(), (String)this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.CHECKPOINT_STORAGE.key().equals(name)) {
                checkpointConfig.setStorage(this.parseCheckpointStorageConfig(node));
                continue;
            }
            LOGGER.warning("Unrecognized element: " + name);
        }
        return checkpointConfig;
    }

    private CheckpointStorageConfig parseCheckpointStorageConfig(Node checkpointStorageConfigNode) {
        CheckpointStorageConfig checkpointStorageConfig = new CheckpointStorageConfig();
        for (Node node : DomConfigHelper.childElements((Node)checkpointStorageConfigNode)) {
            String name = DomConfigHelper.cleanNodeName((Node)node);
            if (ServerConfigOptions.CHECKPOINT_STORAGE_TYPE.key().equals(name)) {
                checkpointStorageConfig.setStorage(this.getTextContent(node));
                continue;
            }
            if (ServerConfigOptions.CHECKPOINT_STORAGE_MAX_RETAINED.key().equals(name)) {
                checkpointStorageConfig.setMaxRetainedCheckpoints(DomConfigHelper.getIntegerValue((String)ServerConfigOptions.CHECKPOINT_STORAGE_MAX_RETAINED.key(), (String)this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.CHECKPOINT_STORAGE_PLUGIN_CONFIG.key().equals(name)) {
                Map<String, String> pluginConfig = this.parseCheckpointPluginConfig(node);
                checkpointStorageConfig.setStoragePluginConfig(pluginConfig);
                continue;
            }
            LOGGER.warning("Unrecognized element: " + name);
        }
        return checkpointStorageConfig;
    }

    private Map<String, String> parseCheckpointPluginConfig(Node checkpointPluginConfigNode) {
        HashMap<String, String> checkpointPluginConfig = new HashMap<String, String>();
        for (Node node : DomConfigHelper.childElements((Node)checkpointPluginConfigNode)) {
            String name = node.getNodeName();
            checkpointPluginConfig.put(name, this.getTextContent(node));
        }
        return checkpointPluginConfig;
    }

    private ConnectorJarStorageConfig parseConnectorJarStorageConfig(Node connectorJarStorageConfigNode) {
        ConnectorJarStorageConfig connectorJarStorageConfig = new ConnectorJarStorageConfig();
        for (Node node : DomConfigHelper.childElements((Node)connectorJarStorageConfigNode)) {
            String name = DomConfigHelper.cleanNodeName((Node)node);
            if (ServerConfigOptions.ENABLE_CONNECTOR_JAR_STORAGE.key().equals(name)) {
                connectorJarStorageConfig.setEnable(DomConfigHelper.getBooleanValue((String)this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.CONNECTOR_JAR_STORAGE_MODE.key().equals(name)) {
                String mode = this.getTextContent(node).toUpperCase();
                if (StringUtils.isNotBlank((CharSequence)mode) && !Arrays.asList("SHARED", "ISOLATED").contains(mode)) {
                    throw new IllegalArgumentException(ServerConfigOptions.CONNECTOR_JAR_STORAGE_MODE + " must in [SHARED, ISOLATED]");
                }
                connectorJarStorageConfig.setStorageMode(ConnectorJarStorageMode.valueOf(mode));
                continue;
            }
            if (ServerConfigOptions.CONNECTOR_JAR_STORAGE_PATH.key().equals(name)) {
                connectorJarStorageConfig.setStoragePath(this.getTextContent(node));
                continue;
            }
            if (ServerConfigOptions.CONNECTOR_JAR_CLEANUP_TASK_INTERVAL.key().equals(name)) {
                connectorJarStorageConfig.setCleanupTaskInterval(DomConfigHelper.getIntegerValue((String)ServerConfigOptions.CONNECTOR_JAR_CLEANUP_TASK_INTERVAL.key(), (String)this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.CONNECTOR_JAR_EXPIRY_TIME.key().equals(name)) {
                connectorJarStorageConfig.setConnectorJarExpiryTime(DomConfigHelper.getIntegerValue((String)ServerConfigOptions.CONNECTOR_JAR_EXPIRY_TIME.key(), (String)this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.CONNECTOR_JAR_HA_STORAGE_CONFIG.key().equals(name)) {
                connectorJarStorageConfig.setConnectorJarHAStorageConfig(this.parseConnectorJarHAStorageConfig(node));
                continue;
            }
            LOGGER.warning("Unrecognized element: " + name);
        }
        return connectorJarStorageConfig;
    }

    private ConnectorJarHAStorageConfig parseConnectorJarHAStorageConfig(Node connectorJarHAStorageConfigNode) {
        ConnectorJarHAStorageConfig connectorJarHAStorageConfig = new ConnectorJarHAStorageConfig();
        for (Node node : DomConfigHelper.childElements((Node)connectorJarHAStorageConfigNode)) {
            String name = DomConfigHelper.cleanNodeName((Node)node);
            if (ServerConfigOptions.CONNECTOR_JAR_HA_STORAGE_TYPE.key().equals(name)) {
                String type = this.getTextContent(node);
                if (StringUtils.isNotBlank((CharSequence)type) && !Arrays.asList("localfile", "hdfs").contains(type)) {
                    throw new IllegalArgumentException(ServerConfigOptions.CONNECTOR_JAR_HA_STORAGE_TYPE + " must in [localfile, hdfs]");
                }
                connectorJarHAStorageConfig.setType(type);
                continue;
            }
            if (ServerConfigOptions.CONNECTOR_JAR_HA_STORAGE_PLUGIN_CONFIG.key().equals(name)) {
                Map<String, String> connectorJarHAStoragePluginConfig = this.parseConnectorJarHAStoragePluginConfig(node);
                connectorJarHAStorageConfig.setStoragePluginConfig(connectorJarHAStoragePluginConfig);
                continue;
            }
            LOGGER.warning("Unrecognized element: " + name);
        }
        return connectorJarHAStorageConfig;
    }

    private Map<String, String> parseConnectorJarHAStoragePluginConfig(Node connectorJarHAStoragePluginConfigNode) {
        HashMap<String, String> connectorJarHAStoragePluginConfig = new HashMap<String, String>();
        for (Node node : DomConfigHelper.childElements((Node)connectorJarHAStoragePluginConfigNode)) {
            String name = node.getNodeName();
            connectorJarHAStoragePluginConfig.put(name, this.getTextContent(node));
        }
        return connectorJarHAStoragePluginConfig;
    }
}

