/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.hazelcast.config.Config;
import com.hazelcast.instance.impl.HazelcastInstanceFactory;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.HazelcastInstanceProxy;
import com.hazelcast.instance.impl.NodeContext;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.config.ConfigProvider;
import org.apache.seatunnel.engine.common.config.EngineConfig;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.server.SeaTunnelNodeContext;

public class SeaTunnelServerStarter {
    public static void main(String[] args) {
        SeaTunnelServerStarter.createHazelcastInstance();
    }

    public static HazelcastInstanceImpl createHazelcastInstance(String clusterName) {
        SeaTunnelConfig seaTunnelConfig = ConfigProvider.locateAndGetSeaTunnelConfig();
        seaTunnelConfig.getHazelcastConfig().setClusterName(clusterName);
        return SeaTunnelServerStarter.createHazelcastInstance(seaTunnelConfig);
    }

    public static HazelcastInstanceImpl createHazelcastInstance(@NonNull SeaTunnelConfig seaTunnelConfig) {
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        return ((HazelcastInstanceProxy)HazelcastInstanceFactory.newHazelcastInstance((Config)seaTunnelConfig.getHazelcastConfig(), (String)HazelcastInstanceFactory.createInstanceName((Config)seaTunnelConfig.getHazelcastConfig()), (NodeContext)new SeaTunnelNodeContext(seaTunnelConfig))).getOriginal();
    }

    public static HazelcastInstanceImpl createMasterAndWorkerHazelcastInstance(@NonNull SeaTunnelConfig seaTunnelConfig) {
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        seaTunnelConfig.getEngineConfig().setClusterRole(EngineConfig.ClusterRole.MASTER_AND_WORKER);
        return ((HazelcastInstanceProxy)HazelcastInstanceFactory.newHazelcastInstance((Config)seaTunnelConfig.getHazelcastConfig(), (String)HazelcastInstanceFactory.createInstanceName((Config)seaTunnelConfig.getHazelcastConfig()), (NodeContext)new SeaTunnelNodeContext(seaTunnelConfig))).getOriginal();
    }

    public static HazelcastInstanceImpl createMasterHazelcastInstance(@NonNull SeaTunnelConfig seaTunnelConfig) {
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        seaTunnelConfig.getEngineConfig().setClusterRole(EngineConfig.ClusterRole.MASTER);
        return ((HazelcastInstanceProxy)HazelcastInstanceFactory.newHazelcastInstance((Config)seaTunnelConfig.getHazelcastConfig(), (String)HazelcastInstanceFactory.createInstanceName((Config)seaTunnelConfig.getHazelcastConfig()), (NodeContext)new SeaTunnelNodeContext(seaTunnelConfig))).getOriginal();
    }

    public static HazelcastInstanceImpl createWorkerHazelcastInstance(@NonNull SeaTunnelConfig seaTunnelConfig) {
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        seaTunnelConfig.getEngineConfig().setClusterRole(EngineConfig.ClusterRole.WORKER);
        seaTunnelConfig.getHazelcastConfig().setLiteMember(true);
        return ((HazelcastInstanceProxy)HazelcastInstanceFactory.newHazelcastInstance((Config)seaTunnelConfig.getHazelcastConfig(), (String)HazelcastInstanceFactory.createInstanceName((Config)seaTunnelConfig.getHazelcastConfig()), (NodeContext)new SeaTunnelNodeContext(seaTunnelConfig))).getOriginal();
    }

    public static HazelcastInstanceImpl createHazelcastInstance() {
        SeaTunnelConfig seaTunnelConfig = ConfigProvider.locateAndGetSeaTunnelConfig();
        return SeaTunnelServerStarter.createHazelcastInstance(seaTunnelConfig);
    }
}

