/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.execution;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.HashMap;
import org.apache.seatunnel.engine.common.Constant;
import org.apache.seatunnel.engine.server.TaskExecutionService;
import org.apache.seatunnel.engine.server.execution.Task;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.metrics.SeaTunnelMetricsContext;
import org.apache.seatunnel.engine.server.utils.NodeEngineUtil;

public class TaskExecutionContext {
    private final Task task;
    private final NodeEngineImpl nodeEngine;
    private final TaskExecutionService taskExecutionService;

    public TaskExecutionContext(Task task, NodeEngineImpl nodeEngine, TaskExecutionService taskExecutionService) {
        this.task = task;
        this.nodeEngine = nodeEngine;
        this.taskExecutionService = taskExecutionService;
    }

    public <E> InvocationFuture<E> sendToMaster(Operation operation) {
        return NodeEngineUtil.sendOperationToMasterNode((NodeEngine)this.nodeEngine, operation);
    }

    public <E> InvocationFuture<E> sendToMember(Operation operation, Address memberID) {
        return NodeEngineUtil.sendOperationToMemberNode((NodeEngine)this.nodeEngine, operation, memberID);
    }

    public ILogger getLogger() {
        return this.nodeEngine.getLogger(this.task.getClass());
    }

    public SeaTunnelMetricsContext getOrCreateMetricsContext(TaskLocation taskLocation) {
        IMap map = this.nodeEngine.getHazelcastInstance().getMap("engine_runningJobMetrics");
        HashMap centralMap = (HashMap)map.get((Object)Constant.IMAP_RUNNING_JOB_METRICS_KEY);
        return centralMap == null || centralMap.get(taskLocation) == null ? new SeaTunnelMetricsContext() : (SeaTunnelMetricsContext)((Object)centralMap.get(taskLocation));
    }

    public <T> T getTask() {
        return (T)this.task;
    }

    public TaskExecutionService getTaskExecutionService() {
        return this.taskExecutionService;
    }

    public HazelcastInstance getInstance() {
        return this.nodeEngine.getHazelcastInstance();
    }
}

