/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.metrics;

import com.hazelcast.cluster.Member;
import com.hazelcast.internal.metrics.MetricConsumer;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.impl.MetricsCompressor;
import com.hazelcast.internal.util.MapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.seatunnel.api.common.metrics.JobMetrics;
import org.apache.seatunnel.api.common.metrics.Measurement;
import org.apache.seatunnel.api.common.metrics.RawJobMetrics;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;

public final class JobMetricsUtil {
    private static ObjectMapper OBJECTMAPPER = new ObjectMapper();

    private JobMetricsUtil() {
    }

    public static String getTaskGroupLocationFromMetricsDescriptor(MetricDescriptor descriptor) {
        for (int i = 0; i < descriptor.tagCount(); ++i) {
            if (!"taskGroupLocation".equals(descriptor.tag(i))) continue;
            return descriptor.tagValue(i);
        }
        return null;
    }

    public static UnaryOperator<MetricDescriptor> addMemberPrefixFn(Member member) {
        String uuid = member.getUuid().toString();
        String addr = member.getAddress().toString();
        return d -> d.copy().withTag("member", uuid).withTag("address", addr);
    }

    public static JobMetrics toJobMetrics(List<RawJobMetrics> rawJobMetrics) {
        JobMetricsConsumer consumer = new JobMetricsConsumer();
        for (RawJobMetrics metrics : rawJobMetrics) {
            if (metrics.getBlob() == null) continue;
            consumer.timestamp = metrics.getTimestamp();
            MetricsCompressor.extractMetrics((byte[])metrics.getBlob(), (MetricConsumer)consumer);
        }
        return JobMetrics.of(consumer.metrics);
    }

    public static String toJsonString(Object o) {
        OBJECTMAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        try {
            return OBJECTMAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            ObjectNode objectNode = OBJECTMAPPER.createObjectNode();
            objectNode.put("err", "serialize JobMetrics err");
            return objectNode.toString();
        }
    }

    public static Map<Long, JobMetrics> toJobMetricsMap(List<RawJobMetrics> rawJobMetrics) {
        metricsConsumer consumer = new metricsConsumer();
        for (RawJobMetrics metrics2 : rawJobMetrics) {
            if (metrics2.getBlob() == null) continue;
            consumer.timestamp = metrics2.getTimestamp();
            MetricsCompressor.extractMetrics((byte[])metrics2.getBlob(), (MetricConsumer)consumer);
        }
        Map jobMetricsMap = MapUtil.createHashMap((int)consumer.metrics.size());
        consumer.metrics.forEach((jobId, metrics) -> jobMetricsMap.put(jobId, JobMetrics.of((Map)metrics)));
        return jobMetricsMap;
    }

    private static class JobMetricsConsumer
    implements MetricConsumer {
        final Map<String, List<Measurement>> metrics = new HashMap<String, List<Measurement>>();
        long timestamp;

        private JobMetricsConsumer() {
        }

        public void consumeLong(MetricDescriptor descriptor, long value) {
            this.metrics.computeIfAbsent(descriptor.metric(), k -> new ArrayList()).add(this.measurement(descriptor, value));
        }

        public void consumeDouble(MetricDescriptor descriptor, double value) {
            this.metrics.computeIfAbsent(descriptor.metric(), k -> new ArrayList()).add(this.measurement(descriptor, value));
        }

        private Measurement measurement(MetricDescriptor descriptor, Object value) {
            Map tags = MapUtil.createHashMap((int)descriptor.tagCount());
            for (int i = 0; i < descriptor.tagCount(); ++i) {
                tags.put(descriptor.tag(i), descriptor.tagValue(i));
            }
            if (descriptor.discriminator() != null || descriptor.discriminatorValue() != null) {
                tags.put(descriptor.discriminator(), descriptor.discriminatorValue());
            }
            return Measurement.of((String)descriptor.metric(), (Object)value, (long)this.timestamp, (Map)tags);
        }
    }

    private static class metricsConsumer
    implements MetricConsumer {
        final Map<Long, Map<String, List<Measurement>>> metrics = new HashMap<Long, Map<String, List<Measurement>>>();
        long timestamp;

        private metricsConsumer() {
        }

        public void consumeLong(MetricDescriptor descriptor, long value) {
            String jobId = descriptor.tagValue("jobId");
            if (jobId == null) {
                return;
            }
            long jobIdLong = Long.parseLong(jobId);
            this.metrics.computeIfAbsent(jobIdLong, k -> new HashMap()).computeIfAbsent(descriptor.metric(), k -> new ArrayList()).add(this.measurement(descriptor, value));
        }

        public void consumeDouble(MetricDescriptor descriptor, double value) {
            String jobId = descriptor.tagValue("jobId");
            if (jobId == null) {
                return;
            }
            long jobIdLong = Long.parseLong(jobId);
            this.metrics.computeIfAbsent(jobIdLong, k -> new HashMap()).computeIfAbsent(descriptor.metric(), k -> new ArrayList()).add(this.measurement(descriptor, value));
        }

        private Measurement measurement(MetricDescriptor descriptor, Object value) {
            Map tags = MapUtil.createHashMap((int)descriptor.tagCount());
            for (int i = 0; i < descriptor.tagCount(); ++i) {
                tags.put(descriptor.tag(i), descriptor.tagValue(i));
            }
            if (descriptor.discriminator() != null || descriptor.discriminatorValue() != null) {
                tags.put(descriptor.discriminator(), descriptor.discriminatorValue());
            }
            return Measurement.of((String)descriptor.metric(), (Object)value, (long)this.timestamp, (Map)tags);
        }
    }
}

