/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.operation;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import lombok.NonNull;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.operation.AbstractJobAsyncOperation;

public class SubmitJobOperation
extends AbstractJobAsyncOperation {
    private Data jobImmutableInformation;
    private boolean isStartWithSavePoint;

    public SubmitJobOperation() {
    }

    public SubmitJobOperation(long jobId, @NonNull Data jobImmutableInformation, boolean isStartWithSavePoint) {
        super(jobId);
        if (jobImmutableInformation == null) {
            throw new NullPointerException("jobImmutableInformation is marked non-null but is null");
        }
        this.jobImmutableInformation = jobImmutableInformation;
        this.isStartWithSavePoint = isStartWithSavePoint;
    }

    public int getClassId() {
        return 1;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        IOUtil.writeData((ObjectDataOutput)out, (Data)this.jobImmutableInformation);
        out.writeBoolean(this.isStartWithSavePoint);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.jobImmutableInformation = IOUtil.readData((ObjectDataInput)in);
        this.isStartWithSavePoint = in.readBoolean();
    }

    @Override
    protected PassiveCompletableFuture<?> doRun() throws Exception {
        SeaTunnelServer seaTunnelServer = (SeaTunnelServer)this.getService();
        return seaTunnelServer.getCoordinatorService().submitJob(this.jobId, this.jobImmutableInformation, this.isStartWithSavePoint);
    }
}

