/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.service.jar;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.List;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.common.config.server.ConnectorJarStorageConfig;
import org.apache.seatunnel.engine.common.config.server.ConnectorJarStorageMode;
import org.apache.seatunnel.engine.core.job.ConnectorJar;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.service.jar.ConnectorJarStorageStrategy;
import org.apache.seatunnel.engine.server.service.jar.SharedConnectorJarStorageStrategy;
import org.apache.seatunnel.engine.server.service.jar.StorageStrategyFactory;
import org.apache.seatunnel.engine.server.task.operation.SendConnectorJarToMemberNodeOperation;
import org.apache.seatunnel.engine.server.utils.NodeEngineUtil;
import org.slf4j.LoggerFactory;

public class ConnectorPackageService {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(ConnectorPackageService.class);
    private static final ILogger LOGGER = Logger.getLogger(ConnectorPackageService.class);
    private final SeaTunnelServer seaTunnelServer;
    private final SeaTunnelConfig seaTunnelConfig;
    private final ConnectorJarStorageConfig connectorJarStorageConfig;
    private final NodeEngineImpl nodeEngine;
    private ConnectorJarStorageStrategy connectorJarStorageStrategy;

    public ConnectorPackageService(SeaTunnelServer seaTunnelServer) {
        this.seaTunnelServer = seaTunnelServer;
        this.seaTunnelConfig = seaTunnelServer.getSeaTunnelConfig();
        this.connectorJarStorageConfig = this.seaTunnelConfig.getEngineConfig().getConnectorJarStorageConfig();
        this.nodeEngine = seaTunnelServer.getNodeEngine();
        this.connectorJarStorageStrategy = StorageStrategyFactory.of(this.connectorJarStorageConfig.getStorageMode(), this.connectorJarStorageConfig, seaTunnelServer);
    }

    public ConnectorJarIdentifier storageConnectorJarFile(long jobId, Data connectorJarData) {
        ConnectorJar connectorJar = (ConnectorJar)this.nodeEngine.getSerializationService().toObject((Object)connectorJarData);
        boolean connectorJarExisted = this.connectorJarStorageStrategy.checkConnectorJarExisted(jobId, connectorJar);
        if (connectorJarExisted) {
            ConnectorJarIdentifier connectorJarIdentifier = this.connectorJarStorageStrategy.getConnectorJarIdentifier(jobId, connectorJar);
            ConnectorJarStorageMode storageMode = this.connectorJarStorageConfig.getStorageMode();
            if (storageMode.equals((Object)ConnectorJarStorageMode.SHARED)) {
                SharedConnectorJarStorageStrategy sharedConnectorJarStorageStrategy = (SharedConnectorJarStorageStrategy)this.connectorJarStorageStrategy;
                sharedConnectorJarStorageStrategy.increaseRefCountForConnectorJar(connectorJarIdentifier);
            }
            return this.connectorJarStorageStrategy.getConnectorJarIdentifier(jobId, connectorJar);
        }
        ConnectorJarIdentifier connectorJarIdentifier = this.connectorJarStorageStrategy.storageConnectorJarFile(jobId, connectorJar);
        this.nodeEngine.getClusterService().getMembers().forEach(member -> {
            Address address = member.getAddress();
            if (!address.equals((Object)this.nodeEngine.getThisAddress())) {
                this.sendConnectorJarToMemberNode(connectorJarIdentifier, connectorJar, address);
            }
        });
        return connectorJarIdentifier;
    }

    private void sendConnectorJarToMemberNode(ConnectorJarIdentifier connectorJarIdentifier, ConnectorJar connectorJar, Address address) {
        InvocationFuture invocationFuture = NodeEngineUtil.sendOperationToMemberNode((NodeEngine)this.nodeEngine, new SendConnectorJarToMemberNodeOperation(connectorJar, connectorJarIdentifier), address);
        invocationFuture.join();
    }

    public void cleanUpWhenJobFinished(long jobId, List<ConnectorJarIdentifier> connectorJarIdentifierList) {
        this.connectorJarStorageStrategy.cleanUpWhenJobFinished(jobId, connectorJarIdentifierList);
    }
}

