/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.seatunnel.api.common.metrics.RawJobMetrics;
import org.apache.seatunnel.engine.server.metrics.ZetaMetricsCollector;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;

public class GetMetricsOperation
extends Operation
implements IdentifiedDataSerializable {
    private RawJobMetrics response;
    private Set<Long> runningJobIds;

    public GetMetricsOperation() {
    }

    public GetMetricsOperation(Set<Long> runningJobIds) {
        this.runningJobIds = runningJobIds;
    }

    public void run() {
        ILogger logger = this.getLogger();
        Address callerAddress = this.getCallerAddress();
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Address masterAddress = this.getNodeEngine().getMasterAddress();
        if (!callerAddress.equals((Object)masterAddress)) {
            throw new IllegalStateException("Caller " + callerAddress + " cannot get metrics because it is not master. Master is: " + masterAddress);
        }
        Predicate<MetricDescriptor> metricDescriptorPredicate = dis -> dis.tagValue("jobId") != null && this.runningJobIds.contains(Long.parseLong(dis.tagValue("jobId")));
        ZetaMetricsCollector metricsRenderer = new ZetaMetricsCollector(metricDescriptorPredicate, (Member)nodeEngine.getLocalMember(), logger);
        nodeEngine.getMetricsRegistry().collect((MetricsCollector)metricsRenderer);
        this.response = metricsRenderer.getMetrics();
    }

    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLongArray(this.runningJobIds.stream().mapToLong(Long::longValue).toArray());
    }

    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.runningJobIds = Arrays.stream(Objects.requireNonNull(in.readLongArray())).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
    }

    public Object getResponse() {
        return this.response;
    }

    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 22;
    }
}

