/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.api.common.metrics.RawJobMetrics;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.metrics.JobMetricsCollector;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;

public class GetTaskGroupMetricsOperation
extends Operation
implements IdentifiedDataSerializable {
    private List<TaskGroupLocation> taskGroupLocations;
    private RawJobMetrics response;

    public GetTaskGroupMetricsOperation() {
    }

    public GetTaskGroupMetricsOperation(List<TaskGroupLocation> taskGroupLocations) {
        this.taskGroupLocations = taskGroupLocations;
    }

    public void run() {
        ILogger logger = this.getLogger();
        Address callerAddress = this.getCallerAddress();
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Address masterAddress = this.getNodeEngine().getMasterAddress();
        if (!callerAddress.equals((Object)masterAddress)) {
            throw new IllegalStateException("Caller " + callerAddress + " cannot get taskGroupLocation metrics" + this.taskGroupLocations.toString() + " because it is not master. Master is: " + masterAddress);
        }
        JobMetricsCollector metricsRenderer = new JobMetricsCollector(this.taskGroupLocations, (Member)nodeEngine.getLocalMember(), logger);
        nodeEngine.getMetricsRegistry().collect((MetricsCollector)metricsRenderer);
        this.response = metricsRenderer.getMetrics();
    }

    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.taskGroupLocations.size());
        for (TaskGroupLocation taskGroupLocation : this.taskGroupLocations) {
            out.writeObject((Object)taskGroupLocation);
        }
    }

    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.taskGroupLocations = new ArrayList<TaskGroupLocation>(size);
        for (int i = 0; i < size; ++i) {
            this.taskGroupLocations.add((TaskGroupLocation)in.readObject());
        }
    }

    public Object getResponse() {
        return this.response;
    }

    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 18;
    }
}

