/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation.source;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;

public class LastCheckpointNotifyOperation
extends Operation
implements IdentifiedDataSerializable {
    private long jobId;
    private TaskLocation taskLocation;

    public LastCheckpointNotifyOperation() {
    }

    public LastCheckpointNotifyOperation(long jobId, TaskLocation taskLocation) {
        this.jobId = jobId;
        this.taskLocation = taskLocation;
    }

    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        server.getCoordinatorService().getJobMaster(this.jobId).getCheckpointManager().readyToClose(this.taskLocation);
    }

    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeObject((Object)this.taskLocation);
    }

    protected void readInternal(ObjectDataInput in) throws IOException {
        this.jobId = in.readLong();
        this.taskLocation = (TaskLocation)in.readObject();
    }

    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 17;
    }
}

