/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.utils;

import com.hazelcast.internal.util.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.core.starter.utils.ConfigBuilder;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class RestUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private RestUtil() {
    }

    public static JsonNode convertByteToJsonNode(byte[] byteData) throws IOException {
        return objectMapper.readTree(byteData);
    }

    public static void buildRequestParams(Map<String, String> requestParams, String uri) {
        requestParams.put("jobId", null);
        requestParams.put("isStartWithSavePoint", String.valueOf(false));
        uri = StringUtil.stripTrailingSlash((String)uri);
        if (!uri.contains("?")) {
            return;
        }
        int indexEnd = uri.indexOf(63);
        try {
            for (String s : uri.substring(indexEnd + 1).split("&")) {
                String[] param = s.split("=");
                requestParams.put(param[0], URLDecoder.decode(param[1], "UTF-8"));
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid Params format in Params.");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported encoding exists in the parameter.");
        }
        if (Boolean.parseBoolean(requestParams.get("isStartWithSavePoint")) && requestParams.get("jobId") == null) {
            throw new IllegalArgumentException("Please provide jobId when start with save point.");
        }
    }

    public static Config buildConfig(JsonNode jsonNode, boolean isEncrypt) {
        Map objectMap = JsonUtils.toMap((JsonNode)jsonNode);
        return ConfigBuilder.of((Map)objectMap, (boolean)isEncrypt);
    }
}

