/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint;

import com.google.common.base.Preconditions;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.core.checkpoint.CheckpointIDCounter;
import org.apache.seatunnel.engine.core.job.PipelineStatus;

public class IMapCheckpointIDCounter
implements CheckpointIDCounter {
    private final Long jobID;
    private final Integer pipelineId;
    private final String key;
    private final IMap<String, Long> checkpointIdMap;

    public IMapCheckpointIDCounter(Long jobID, Integer pipelineId, NodeEngine nodeEngine) {
        this.jobID = jobID;
        this.pipelineId = pipelineId;
        this.key = IMapCheckpointIDCounter.convertLongIntToBase64(jobID, pipelineId);
        this.checkpointIdMap = nodeEngine.getHazelcastInstance().getMap("engine_checkpoint-id-map");
    }

    public void start() throws Exception {
        RetryUtils.retryWithException(() -> (Long)this.checkpointIdMap.putIfAbsent((Object)this.key, (Object)1L), (RetryUtils.RetryMaterial)new RetryUtils.RetryMaterial(30, true, exception -> ExceptionUtil.isOperationNeedRetryException((Throwable)exception), 2000L));
    }

    public CompletableFuture<Void> shutdown(PipelineStatus pipelineStatus) {
        if (pipelineStatus.isEndState()) {
            this.checkpointIdMap.remove((Object)this.key);
        }
        return CompletableFuture.completedFuture(null);
    }

    public long getAndIncrement() throws Exception {
        Long nextId = (Long)this.checkpointIdMap.compute((Object)this.key, (k, v) -> v == null ? null : Long.valueOf(v + 1L));
        Preconditions.checkNotNull((Object)nextId);
        return nextId - 1L;
    }

    public long get() {
        return (Long)this.checkpointIdMap.get((Object)this.key);
    }

    public void setCount(long newId) throws Exception {
        this.checkpointIdMap.put((Object)this.key, (Object)newId);
    }

    public static String convertLongIntToBase64(long longValue, int intValue) {
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.putLong(longValue);
        buffer.putInt(intValue);
        byte[] bytes = buffer.array();
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static long[] convertBase64ToLongInt(String encodedStr) {
        byte[] decodedBytes = Base64.getDecoder().decode(encodedStr);
        ByteBuffer buffer = ByteBuffer.wrap(decodedBytes);
        long longValue = buffer.getLong();
        int intValue = buffer.getInt();
        return new long[]{longValue, intValue};
    }
}

