/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint.operation;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.server.CoordinatorService;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.CheckpointDataSerializerHook;
import org.apache.seatunnel.engine.server.task.operation.TracingOperation;
import org.apache.seatunnel.engine.server.task.statemachine.SeaTunnelTaskState;

public class TaskReportStatusOperation
extends TracingOperation
implements IdentifiedDataSerializable {
    private TaskLocation location;
    private SeaTunnelTaskState status;

    public int getFactoryId() {
        return CheckpointDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 4;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject((Object)this.location);
        out.writeObject((Object)this.status);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.location = (TaskLocation)in.readObject(TaskLocation.class);
        this.status = (SeaTunnelTaskState)in.readObject();
    }

    @Override
    public void runInternal() throws Exception {
        CoordinatorService coordinatorService = ((SeaTunnelServer)this.getService()).getCoordinatorService();
        RetryUtils.retryWithException(() -> {
            coordinatorService.getJobMaster(this.location.getJobId()).getCheckpointManager().reportedTask(this);
            return null;
        }, (RetryUtils.RetryMaterial)new RetryUtils.RetryMaterial(30, true, e -> true, 2000L));
    }

    public TaskLocation getLocation() {
        return this.location;
    }

    public SeaTunnelTaskState getStatus() {
        return this.status;
    }

    public TaskReportStatusOperation() {
    }

    public TaskReportStatusOperation(TaskLocation location, SeaTunnelTaskState status) {
        this.location = location;
        this.status = status;
    }
}

