/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.log;

import com.hazelcast.internal.ascii.TextCommand;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommand;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpGetCommand;
import com.hazelcast.internal.ascii.rest.HttpGetCommandProcessor;
import com.hazelcast.internal.json.JsonObject;
import java.util.Map;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Log4j2HttpGetCommandProcessor
extends HttpCommandProcessor<HttpGetCommand> {
    private final HttpGetCommandProcessor original;

    public Log4j2HttpGetCommandProcessor(TextCommandService textCommandService) {
        this(textCommandService, new HttpGetCommandProcessor(textCommandService));
    }

    public Log4j2HttpGetCommandProcessor(TextCommandService textCommandService, HttpGetCommandProcessor httpGetCommandProcessor) {
        super(textCommandService, textCommandService.getNode().getLogger(Log4j2HttpGetCommandProcessor.class));
        this.original = httpGetCommandProcessor;
    }

    public void handleRejection(HttpGetCommand request) {
        this.handle(request);
    }

    public void handle(HttpGetCommand request) {
        String uri = request.getURI();
        if (uri.startsWith("/hazelcast/rest/log-level")) {
            this.outputAllLoggerLevel(request);
        } else {
            this.original.handle(request);
        }
    }

    private void outputAllLoggerLevel(HttpGetCommand request) {
        JsonObject jsonObject = new JsonObject();
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        Map loggers = loggerContext.getConfiguration().getLoggers();
        for (String logger : loggers.keySet()) {
            LoggerConfig config = (LoggerConfig)loggers.get(logger);
            if ("".equals(logger)) {
                logger = "root";
            }
            jsonObject.set(logger, config.getLevel().name());
        }
        this.prepareResponse((HttpCommand)request, jsonObject);
        this.textCommandService.sendResponse((TextCommand)request);
    }
}

