/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.operation;

import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.spi.impl.operationservice.Operation;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.serializable.ClientToServerOperationDataSerializerHook;

public abstract class AsyncOperation
extends Operation
implements IdentifiedDataSerializable {
    public void beforeRun() {
        SeaTunnelServer service = (SeaTunnelServer)this.getService();
        service.getLiveOperationRegistry().register((Operation)this);
    }

    public final void run() {
        PassiveCompletableFuture<?> future;
        try {
            future = this.doRun();
        }
        catch (Exception e) {
            this.logError(e);
            this.doSendResponse(e);
            return;
        }
        future.whenComplete(ExceptionUtil.withTryCatch((ILogger)this.getLogger(), (r, f) -> this.doSendResponse(f != null ? ExceptionUtil.peel((Throwable)f) : r)));
    }

    protected abstract PassiveCompletableFuture<?> doRun() throws Exception;

    public final boolean returnsResponse() {
        return false;
    }

    public final Object getResponse() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendResponse(Object value) {
        try {
            SeaTunnelServer service = (SeaTunnelServer)this.getService();
            service.getLiveOperationRegistry().deregister((Operation)this);
        }
        finally {
            try {
                this.sendResponse(value);
            }
            catch (Exception e) {
                Throwable ex = ExceptionUtil.peel((Throwable)e);
                if (value instanceof Throwable && ex instanceof HazelcastSerializationException) {
                    this.sendResponse((Object)new SeaTunnelEngineException(ExceptionUtil.stackTraceToString((Throwable)ex)));
                }
                throw e;
            }
        }
    }

    public ExceptionAction onInvocationException(Throwable throwable) {
        return ExceptionUtil.isRestartableException((Throwable)throwable) ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }

    public final int getFactoryId() {
        return ClientToServerOperationDataSerializerHook.FACTORY_ID;
    }
}

