/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.task.operation.TracingOperation;

public class GetTaskGroupAddressOperation
extends TracingOperation
implements IdentifiedDataSerializable {
    private TaskLocation taskLocation;
    private Address response;

    public GetTaskGroupAddressOperation() {
    }

    public GetTaskGroupAddressOperation(TaskLocation taskLocation) {
        this.taskLocation = taskLocation;
    }

    @Override
    public void runInternal() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        this.response = (Address)RetryUtils.retryWithException(() -> server.getCoordinatorService().getJobMaster(this.taskLocation.getJobId()).queryTaskGroupAddress(this.taskLocation.getTaskGroupLocation()), (RetryUtils.RetryMaterial)new RetryUtils.RetryMaterial(30, true, Objects::nonNull, 2000L));
    }

    public Object getResponse() {
        return this.response;
    }

    public String getServiceName() {
        return "st:impl:seaTunnelServer";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject((Object)this.taskLocation);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.taskLocation = (TaskLocation)in.readObject();
    }

    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 6;
    }
}

