/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.seatunnel.api.serialization.SerializationSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.format.avro.RowToAvroConverter;
import org.apache.seatunnel.format.avro.exception.AvroFormatErrorCode;
import org.apache.seatunnel.format.avro.exception.SeaTunnelAvroFormatException;

public class AvroSerializationSchema
implements SerializationSchema {
    private static final long serialVersionUID = 4438784443025715370L;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)this.out, null);
    private final RowToAvroConverter converter;
    private final DatumWriter<GenericRecord> writer;

    public AvroSerializationSchema(SeaTunnelRowType rowType) {
        this.converter = new RowToAvroConverter(rowType);
        this.writer = this.converter.getWriter();
    }

    public byte[] serialize(SeaTunnelRow element) {
        GenericRecord record = this.converter.convertRowToGenericRecord(element);
        try {
            this.writer.write((Object)record, (Encoder)this.encoder);
            this.encoder.flush();
            byte[] byArray = this.out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new SeaTunnelAvroFormatException(AvroFormatErrorCode.SERIALIZATION_ERROR, "Serialization error on record : " + element);
        }
        finally {
            this.out.reset();
        }
    }
}

