/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.avro;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.Schema;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.format.avro.SeaTunnelRowTypeToAvroSchemaConverter;
import org.apache.seatunnel.format.avro.exception.AvroFormatErrorCode;
import org.apache.seatunnel.format.avro.exception.SeaTunnelAvroFormatException;

public class AvroToRowConverter
implements Serializable {
    private static final long serialVersionUID = 8177020083886379563L;
    private DatumReader<GenericRecord> reader = null;
    private Schema schema;

    public AvroToRowConverter(SeaTunnelRowType rowType) {
        this.schema = SeaTunnelRowTypeToAvroSchemaConverter.buildAvroSchemaWithRowType(rowType);
    }

    public DatumReader<GenericRecord> getReader() {
        if (this.reader == null) {
            this.reader = this.createReader();
        }
        return this.reader;
    }

    private DatumReader<GenericRecord> createReader() {
        GenericDatumReader datumReader = new GenericDatumReader(this.schema, this.schema);
        datumReader.getData().addLogicalTypeConversion((Conversion)new Conversions.DecimalConversion());
        datumReader.getData().addLogicalTypeConversion((Conversion)new TimeConversions.DateConversion());
        datumReader.getData().addLogicalTypeConversion((Conversion)new TimeConversions.LocalTimestampMillisConversion());
        return datumReader;
    }

    public SeaTunnelRow converter(GenericRecord record, SeaTunnelRowType rowType) {
        String[] fieldNames = rowType.getFieldNames();
        Object[] values = new Object[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            values[i] = record.getSchema().getField(fieldNames[i]) == null ? null : this.convertField(rowType.getFieldType(i), record.get(fieldNames[i]));
        }
        return new SeaTunnelRow(values);
    }

    private Object convertField(SeaTunnelDataType<?> dataType, Object val) {
        if (Objects.isNull(val)) {
            return null;
        }
        switch (dataType.getSqlType()) {
            case STRING: {
                return val.toString();
            }
            case BOOLEAN: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case NULL: 
            case DATE: 
            case DECIMAL: 
            case TIMESTAMP: {
                return val;
            }
            case BYTES: {
                return ((ByteBuffer)val).array();
            }
            case SMALLINT: {
                return ((Integer)val).shortValue();
            }
            case TINYINT: {
                Class typeClass = dataType.getTypeClass();
                if (typeClass == Byte.class) {
                    Integer integer = (Integer)val;
                    return integer.byteValue();
                }
                return val;
            }
            case MAP: {
                MapType mapType = (MapType)dataType;
                HashMap<Object, Object> res = new HashMap<Object, Object>();
                Map map = (Map)val;
                for (Map.Entry o : map.entrySet()) {
                    res.put(this.convertField(mapType.getKeyType(), o.getKey()), this.convertField(mapType.getValueType(), o.getValue()));
                }
                return res;
            }
            case ARRAY: {
                SeaTunnelDataType basicType = ((ArrayType)dataType).getElementType();
                List list = (List)val;
                return this.convertArray(list, basicType);
            }
            case ROW: {
                SeaTunnelRowType subRow = (SeaTunnelRowType)dataType;
                return this.converter((GenericRecord)val, subRow);
            }
        }
        String errorMsg = String.format("SeaTunnel avro format is not supported for this data type [%s]", dataType.getSqlType());
        throw new SeaTunnelAvroFormatException(AvroFormatErrorCode.UNSUPPORTED_DATA_TYPE, errorMsg);
    }

    protected Object convertArray(List<Object> val, SeaTunnelDataType<?> dataType) {
        if (val == null) {
            return null;
        }
        int length = val.size();
        Object instance = Array.newInstance(dataType.getTypeClass(), length);
        for (int i = 0; i < val.size(); ++i) {
            Array.set(instance, i, this.convertField(dataType, val.get(i)));
        }
        return instance;
    }
}

