/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.io.IOException;
import java.util.Optional;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.format.protobuf.ProtobufToRowConverter;

public class ProtobufDeserializationSchema
implements DeserializationSchema<SeaTunnelRow> {
    private static final long serialVersionUID = -7907358485475741366L;
    private final SeaTunnelRowType rowType;
    private final ProtobufToRowConverter converter;
    private final CatalogTable catalogTable;
    private final String protoContent;
    private final String messageName;

    public ProtobufDeserializationSchema(CatalogTable catalogTable) {
        this.catalogTable = catalogTable;
        this.rowType = catalogTable.getSeaTunnelRowType();
        this.messageName = (String)catalogTable.getOptions().get("protobuf_message_name");
        this.protoContent = (String)catalogTable.getOptions().get("protobuf_schema");
        this.converter = new ProtobufToRowConverter(this.protoContent, this.messageName);
    }

    public SeaTunnelRow deserialize(byte[] message) throws IOException {
        Descriptors.Descriptor descriptor = this.converter.getDescriptor();
        DynamicMessage dynamicMessage = DynamicMessage.parseFrom((Descriptors.Descriptor)descriptor, (byte[])message);
        SeaTunnelRow seaTunnelRow = this.converter.converter(descriptor, dynamicMessage, this.rowType);
        Optional<TablePath> tablePath = Optional.ofNullable(this.catalogTable).map(CatalogTable::getTablePath);
        if (tablePath.isPresent()) {
            seaTunnelRow.setTableId(tablePath.toString());
        }
        return seaTunnelRow;
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.rowType;
    }
}

