/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.format.protobuf.exception.ProtobufFormatErrorCode;
import org.apache.seatunnel.format.protobuf.exception.SeaTunnelProtobufFormatException;

public class RowToProtobufConverter
implements Serializable {
    private static final long serialVersionUID = -576124379280229724L;
    private final Descriptors.Descriptor descriptor;
    private final SeaTunnelRowType rowType;

    public RowToProtobufConverter(SeaTunnelRowType rowType, Descriptors.Descriptor descriptor) {
        this.rowType = rowType;
        this.descriptor = descriptor;
    }

    public byte[] convertRowToGenericRecord(SeaTunnelRow element) {
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)this.descriptor);
        String[] fieldNames = this.rowType.getFieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            Object value;
            String fieldName = this.rowType.getFieldName(i);
            Object resolvedValue = this.resolveObject(fieldName, value = element.getField(i), this.rowType.getFieldType(i), builder);
            if (resolvedValue == null) continue;
            if (resolvedValue instanceof byte[]) {
                resolvedValue = ByteString.copyFrom((byte[])((byte[])resolvedValue));
            }
            builder.setField(this.descriptor.findFieldByName(fieldName.toLowerCase()), resolvedValue);
        }
        return builder.build().toByteArray();
    }

    private Object resolveObject(String fieldName, Object data, SeaTunnelDataType<?> seaTunnelDataType, DynamicMessage.Builder builder) {
        if (data == null) {
            return null;
        }
        switch (seaTunnelDataType.getSqlType()) {
            case STRING: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case DECIMAL: 
            case DATE: 
            case TIMESTAMP: 
            case BYTES: {
                return data;
            }
            case TINYINT: {
                if (data instanceof Byte) {
                    return Byte.toUnsignedInt((Byte)data);
                }
                return data;
            }
            case MAP: {
                return this.handleMapType(fieldName, data, seaTunnelDataType, builder);
            }
            case ARRAY: {
                return Arrays.asList((Object[])data);
            }
            case ROW: {
                return this.handleRowType(fieldName, data, seaTunnelDataType);
            }
        }
        throw new SeaTunnelProtobufFormatException(ProtobufFormatErrorCode.UNSUPPORTED_DATA_TYPE, String.format("SeaTunnel protobuf format is not supported for this data type [%s]", seaTunnelDataType.getSqlType()));
    }

    private Object handleMapType(String fieldName, Object data, SeaTunnelDataType<?> seaTunnelDataType, DynamicMessage.Builder builder) {
        Descriptors.Descriptor mapEntryDescriptor = this.descriptor.findFieldByName(fieldName).getMessageType();
        if (data instanceof Map) {
            Map mapData = (Map)data;
            mapData.forEach((key, value) -> {
                DynamicMessage mapEntry = DynamicMessage.newBuilder((Descriptors.Descriptor)mapEntryDescriptor).setField(mapEntryDescriptor.findFieldByName("key"), key).setField(mapEntryDescriptor.findFieldByName("value"), value).build();
                builder.addRepeatedField(this.descriptor.findFieldByName(fieldName), (Object)mapEntry);
            });
        }
        return null;
    }

    private Object handleRowType(String fieldName, Object data, SeaTunnelDataType<?> seaTunnelDataType) {
        SeaTunnelRow seaTunnelRow = (SeaTunnelRow)data;
        SeaTunnelDataType[] fieldTypes = ((SeaTunnelRowType)seaTunnelDataType).getFieldTypes();
        String[] fieldNames = ((SeaTunnelRowType)seaTunnelDataType).getFieldNames();
        Descriptors.Descriptor nestedTypeDescriptor = this.descriptor.findNestedTypeByName(fieldName);
        DynamicMessage.Builder nestedBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)nestedTypeDescriptor);
        for (int i = 0; i < fieldNames.length; ++i) {
            Object resolvedValue = this.resolveObject(fieldNames[i], seaTunnelRow.getField(i), fieldTypes[i], nestedBuilder);
            nestedBuilder.setField(nestedTypeDescriptor.findFieldByName(fieldNames[i]), resolvedValue);
        }
        return nestedBuilder.build();
    }
}

