/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import com.google.protobuf.TextFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.yarn.api.protocolrecords.ContainerUpdateRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.impl.pb.TokenPBImpl;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ContainerUpdateRequestPBImpl
extends ContainerUpdateRequest {
    private YarnServiceProtos.ContainerUpdateRequestProto proto = YarnServiceProtos.ContainerUpdateRequestProto.getDefaultInstance();
    private YarnServiceProtos.ContainerUpdateRequestProto.Builder builder = null;
    private boolean viaProto = false;
    private List<Token> containersToUpdate = null;

    public ContainerUpdateRequestPBImpl() {
        this.builder = YarnServiceProtos.ContainerUpdateRequestProto.newBuilder();
    }

    public ContainerUpdateRequestPBImpl(YarnServiceProtos.ContainerUpdateRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    @Override
    public List<Token> getContainersToUpdate() {
        if (this.containersToUpdate != null) {
            return this.containersToUpdate;
        }
        YarnServiceProtos.ContainerUpdateRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<SecurityProtos.TokenProto> list = p.getUpdateContainerTokenList();
        this.containersToUpdate = new ArrayList<Token>();
        for (SecurityProtos.TokenProto c : list) {
            this.containersToUpdate.add(this.convertFromProtoFormat(c));
        }
        return this.containersToUpdate;
    }

    @Override
    public void setContainersToUpdate(List<Token> containersToUpdate) {
        this.maybeInitBuilder();
        if (containersToUpdate == null) {
            this.builder.clearUpdateContainerToken();
        }
        this.containersToUpdate = containersToUpdate;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ContainerUpdateRequestPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    public YarnServiceProtos.ContainerUpdateRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private Token convertFromProtoFormat(SecurityProtos.TokenProto p) {
        return new TokenPBImpl(p);
    }

    private SecurityProtos.TokenProto convertToProtoFormat(Token t) {
        return ((TokenPBImpl)t).getProto();
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.ContainerUpdateRequestProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void mergeLocalToBuilder() {
        if (this.containersToUpdate != null) {
            this.addUpdateContainersToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void addUpdateContainersToProto() {
        this.maybeInitBuilder();
        this.builder.clearUpdateContainerToken();
        if (this.containersToUpdate == null) {
            return;
        }
        Iterable<SecurityProtos.TokenProto> iterable = new Iterable<SecurityProtos.TokenProto>(){

            @Override
            public Iterator<SecurityProtos.TokenProto> iterator() {
                return new Iterator<SecurityProtos.TokenProto>(){
                    private Iterator<Token> iter;
                    {
                        this.iter = ContainerUpdateRequestPBImpl.this.containersToUpdate.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public SecurityProtos.TokenProto next() {
                        return ContainerUpdateRequestPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllUpdateContainerToken((Iterable<? extends SecurityProtos.TokenProto>)iterable);
    }
}

