/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.EOFException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.net.ConnectTimeoutException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.exceptions.NMNotYetReadyException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.seatunnel.shade.hadoop.com.google.common.base.Preconditions;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ServerProxy {
    protected static RetryPolicy createRetryPolicy(Configuration conf, String maxWaitTimeStr, long defMaxWaitTime, String connectRetryIntervalStr, long defRetryInterval) {
        long maxWaitTime = conf.getLong(maxWaitTimeStr, defMaxWaitTime);
        long retryIntervalMS = conf.getLong(connectRetryIntervalStr, defRetryInterval);
        Preconditions.checkArgument(maxWaitTime == -1L || maxWaitTime > 0L, "Invalid Configuration. " + maxWaitTimeStr + " should be either positive value or -1.");
        Preconditions.checkArgument(retryIntervalMS > 0L, "Invalid Configuration. " + connectRetryIntervalStr + "should be a positive value.");
        RetryPolicy retryPolicy = null;
        retryPolicy = maxWaitTime == -1L ? RetryPolicies.retryForeverWithFixedSleep(retryIntervalMS, TimeUnit.MILLISECONDS) : RetryPolicies.retryUpToMaximumTimeWithFixedSleep(maxWaitTime, retryIntervalMS, TimeUnit.MILLISECONDS);
        HashMap<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<? extends Exception>, RetryPolicy>();
        exceptionToPolicyMap.put(EOFException.class, retryPolicy);
        exceptionToPolicyMap.put(ConnectException.class, retryPolicy);
        exceptionToPolicyMap.put(NoRouteToHostException.class, retryPolicy);
        exceptionToPolicyMap.put(UnknownHostException.class, retryPolicy);
        exceptionToPolicyMap.put(ConnectTimeoutException.class, retryPolicy);
        exceptionToPolicyMap.put(RetriableException.class, retryPolicy);
        exceptionToPolicyMap.put(SocketException.class, retryPolicy);
        exceptionToPolicyMap.put(NMNotYetReadyException.class, retryPolicy);
        return RetryPolicies.retryByException(RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
    }

    protected static <T> T createRetriableProxy(final Configuration conf, final Class<T> protocol, UserGroupInformation user, final YarnRPC rpc, final InetSocketAddress serverAddress, RetryPolicy retryPolicy) {
        Object proxy = user.doAs(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return rpc.getProxy(protocol, serverAddress, conf);
            }
        });
        return (T)RetryProxy.create(protocol, proxy, retryPolicy);
    }
}

