/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig;

import com.hazelcast.internal.config.ConfigNamespace;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import java.util.Collections;
import java.util.Set;

public class ConfigUpdateResult {
    public static final ConfigUpdateResult EMPTY = new ConfigUpdateResult(Collections.emptySet(), Collections.emptySet());
    private final Set<ConfigNamespace> addedConfigs;
    private final Set<ConfigNamespace> ignoredConfigs;

    public ConfigUpdateResult(Set<ConfigNamespace> addedConfigs, Set<ConfigNamespace> ignoredConfigs) {
        this.addedConfigs = addedConfigs;
        this.ignoredConfigs = ignoredConfigs;
    }

    public Set<ConfigNamespace> getAddedConfigs() {
        return this.addedConfigs;
    }

    public Set<ConfigNamespace> getIgnoredConfigs() {
        return this.ignoredConfigs;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonArray addedConfigsAsJson = this.toJsonArray(this.addedConfigs);
        JsonArray ignoredConfigsAsJson = this.toJsonArray(this.ignoredConfigs);
        json.add("addedConfigs", addedConfigsAsJson);
        json.add("ignoredConfigs", ignoredConfigsAsJson);
        return json;
    }

    private JsonArray toJsonArray(Set<ConfigNamespace> configs) {
        JsonArray configsAsJson = new JsonArray();
        for (ConfigNamespace ns : configs) {
            JsonObject namespaceAsJson = new JsonObject();
            namespaceAsJson.add("sectionName", ns.getSectionName());
            namespaceAsJson.add("configName", ns.getConfigName());
            configsAsJson.add(namespaceAsJson);
        }
        return configsAsJson;
    }
}

