/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.util.Preconditions;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DynamicConfigurationConfig {
    public static final String DEFAULT_BACKUP_DIR = "dynamic-configuration-backups";
    public static final int DEFAULT_BACKUP_COUNT = 5;
    private boolean persistenceEnabled;
    private File backupDir = new File("dynamic-configuration-backups");
    private int backupCount = 5;

    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    @Nonnull
    public DynamicConfigurationConfig setPersistenceEnabled(boolean persistenceEnabled) {
        this.persistenceEnabled = persistenceEnabled;
        return this;
    }

    @Nonnull
    public File getBackupDir() {
        return this.backupDir;
    }

    @Nonnull
    public DynamicConfigurationConfig setBackupDir(@Nonnull File backupDir) {
        Preconditions.checkNotNull(backupDir);
        this.backupDir = backupDir;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    @Nonnull
    public DynamicConfigurationConfig setBackupCount(int backupCount) {
        this.backupCount = backupCount;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicConfigurationConfig that = (DynamicConfigurationConfig)o;
        return this.persistenceEnabled == that.persistenceEnabled && this.backupCount == that.backupCount && Objects.equals(this.backupDir, that.backupDir);
    }

    public int hashCode() {
        int result = this.persistenceEnabled ? 1 : 0;
        result = 31 * result + (this.backupDir != null ? this.backupDir.hashCode() : 0);
        result = 31 * result + this.backupCount;
        return result;
    }

    public String toString() {
        return "DynamicConfigurationConfig{persistenceEnabled=" + this.persistenceEnabled + ", backupDir=" + this.backupDir + ", backupCount=" + this.backupCount + '}';
    }
}

