/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.plugin.discovery;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.seatunnel.api.common.PluginIdentifier;
import org.apache.seatunnel.api.common.PluginIdentifierInterface;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableTransformFactory;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.utils.FileUtils;
import org.apache.seatunnel.common.utils.ReflectionUtils;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.plugin.discovery.PluginDiscovery;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigResolveOptions;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPluginDiscovery<T>
implements PluginDiscovery<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractPluginDiscovery.class);
    private static final String PLUGIN_MAPPING_FILE = "plugin-mapping.properties";
    private static final BiConsumer<ClassLoader, List<URL>> DEFAULT_URL_TO_CLASSLOADER = (classLoader, urls) -> {
        if (!(classLoader instanceof URLClassLoader)) {
            throw new UnsupportedOperationException("can't support custom load jar");
        }
        urls.forEach(url -> ReflectionUtils.invoke((Object)classLoader, (String)"addURL", (Object[])new Object[]{url}));
    };
    private final Path pluginDir;
    private final Config pluginMappingConfig;
    private final BiConsumer<ClassLoader, List<URL>> addURLToClassLoaderConsumer;
    protected final ConcurrentHashMap<PluginIdentifier, Optional<List<URL>>> pluginJarPath = new ConcurrentHashMap(16);
    protected final Map<PluginIdentifier, String> sourcePluginInstance;
    protected final Map<PluginIdentifier, String> sinkPluginInstance;
    protected final Map<PluginIdentifier, String> transformPluginInstance;

    public AbstractPluginDiscovery(BiConsumer<ClassLoader, List<URL>> addURLToClassloader) {
        this(Common.connectorDir(), AbstractPluginDiscovery.loadConnectorPluginConfig(), addURLToClassloader);
    }

    public AbstractPluginDiscovery() {
        this(Common.connectorDir(), AbstractPluginDiscovery.loadConnectorPluginConfig());
    }

    public AbstractPluginDiscovery(Path pluginDir) {
        this(pluginDir, AbstractPluginDiscovery.loadConnectorPluginConfig());
    }

    public AbstractPluginDiscovery(Path pluginDir, Config pluginMappingConfig) {
        this(pluginDir, pluginMappingConfig, DEFAULT_URL_TO_CLASSLOADER);
    }

    public AbstractPluginDiscovery(Path pluginDir, Config pluginMappingConfig, BiConsumer<ClassLoader, List<URL>> addURLToClassLoaderConsumer) {
        this.pluginDir = pluginDir;
        this.pluginMappingConfig = pluginMappingConfig;
        this.addURLToClassLoaderConsumer = addURLToClassLoaderConsumer;
        this.sourcePluginInstance = AbstractPluginDiscovery.getAllSupportedPlugins(PluginType.SOURCE);
        this.sinkPluginInstance = AbstractPluginDiscovery.getAllSupportedPlugins(PluginType.SINK);
        this.transformPluginInstance = AbstractPluginDiscovery.getAllSupportedPlugins(PluginType.TRANSFORM);
        log.info("Load {} Plugin from {}", (Object)this.getPluginBaseClass().getSimpleName(), (Object)pluginDir);
    }

    protected static Config loadConnectorPluginConfig() {
        return ConfigFactory.parseFile((File)Common.connectorDir().resolve(PLUGIN_MAPPING_FILE).toFile()).resolve(ConfigResolveOptions.defaults().setAllowUnresolved(true));
    }

    @Override
    public List<URL> getPluginJarPaths(List<PluginIdentifier> pluginIdentifiers) {
        return pluginIdentifiers.stream().map(this::getPluginJarPath).filter(Optional::isPresent).map(Optional::get).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @Override
    public List<URL> getPluginJarAndDependencyPaths(List<PluginIdentifier> pluginIdentifiers) {
        return pluginIdentifiers.stream().flatMap(pluginIdentifier -> {
            try {
                List<URL> jars = this.getPluginDependencyJarPaths((PluginIdentifier)pluginIdentifier);
                this.getPluginJarPath((PluginIdentifier)pluginIdentifier).ifPresent(jars::addAll);
                log.info("find connector jar and dependency for {}: {}", pluginIdentifier, jars);
                return jars.stream();
            }
            catch (IOException e) {
                log.warn("get plugin dependency jar path failed, pluginIdentifier: {}", pluginIdentifier, (Object)e);
                return Stream.empty();
            }
        }).distinct().sorted(Comparator.comparing(URL::toString)).collect(Collectors.toList());
    }

    @Override
    public List<T> getAllPlugins(List<PluginIdentifier> pluginIdentifiers) {
        return pluginIdentifiers.stream().map(this::createPluginInstance).distinct().collect(Collectors.toList());
    }

    public static Map<PluginIdentifier, String> getAllSupportedPlugins(PluginType pluginType) {
        Config config = AbstractPluginDiscovery.loadConnectorPluginConfig();
        HashMap<PluginIdentifier, String> pluginIdentifiers = new HashMap<PluginIdentifier, String>();
        if (config.isEmpty() || !config.hasPath("seatunnel")) {
            return pluginIdentifiers;
        }
        Config engineConfig = config.getConfig("seatunnel");
        if (engineConfig.hasPath(pluginType.getType())) {
            engineConfig.getConfig(pluginType.getType()).entrySet().forEach(entry -> pluginIdentifiers.put(PluginIdentifier.of((String)"seatunnel", (String)pluginType.getType(), (String)((String)entry.getKey())), ((ConfigValue)entry.getValue()).unwrapped().toString()));
        }
        return pluginIdentifiers;
    }

    @Override
    public T createPluginInstance(PluginIdentifier pluginIdentifier) {
        return this.createPluginInstance(pluginIdentifier, Collections.EMPTY_LIST);
    }

    @Override
    public Optional<T> createOptionalPluginInstance(PluginIdentifier pluginIdentifier) {
        return this.createOptionalPluginInstance(pluginIdentifier, Collections.EMPTY_LIST);
    }

    @Override
    public Optional<T> createOptionalPluginInstance(PluginIdentifier pluginIdentifier, Collection<URL> pluginJars) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        T pluginInstance = this.loadPluginInstance(pluginIdentifier, classLoader);
        if (pluginInstance != null) {
            log.info("Load plugin: {} from classpath", (Object)pluginIdentifier);
            return Optional.of(pluginInstance);
        }
        Optional<List<URL>> pluginJarPaths = this.getPluginJarPath(pluginIdentifier);
        if (pluginJarPaths.isPresent()) {
            try {
                this.addURLToClassLoaderConsumer.accept(classLoader, pluginJarPaths.get());
                this.addURLToClassLoaderConsumer.accept(classLoader, (List)pluginJars);
            }
            catch (Exception e) {
                log.warn("can't load jar use current thread classloader, use URLClassLoader instead now. message: " + e.getMessage());
                URL[] urls = new URL[pluginJars.size() + 1];
                int i = 0;
                for (URL pluginJar : pluginJars) {
                    urls[i++] = pluginJar;
                }
                urls = (URL[])Stream.concat(Arrays.stream(urls), pluginJarPaths.get().stream()).distinct().toArray(URL[]::new);
                classLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
            }
            pluginInstance = this.loadPluginInstance(pluginIdentifier, classLoader);
            if (pluginInstance != null) {
                log.info("Load plugin: {} from path: {} use classloader: {}", new Object[]{pluginIdentifier, pluginJarPaths.get(), classLoader.getClass().getName()});
                return Optional.of(pluginInstance);
            }
        }
        return Optional.empty();
    }

    @Override
    public T createPluginInstance(PluginIdentifier pluginIdentifier, Collection<URL> pluginJars) {
        Optional<T> instance = this.createOptionalPluginInstance(pluginIdentifier, pluginJars);
        if (instance.isPresent()) {
            return instance.get();
        }
        throw new RuntimeException("Plugin " + pluginIdentifier + " not found.");
    }

    @Override
    public ImmutableTriple<PluginIdentifier, List<Option<?>>, List<Option<?>>> getOptionRules(String pluginIdentifier) {
        Optional<Map.Entry> pluginEntry = this.getPlugins().entrySet().stream().filter(entry -> ((PluginIdentifier)entry.getKey()).getPluginName().equalsIgnoreCase(pluginIdentifier)).findFirst();
        if (pluginEntry.isPresent()) {
            Map.Entry entry2 = pluginEntry.get();
            List requiredOptions = ((OptionRule)entry2.getValue()).getRequiredOptions().stream().flatMap(requiredOption -> requiredOption.getOptions().stream()).collect(Collectors.toList());
            List optionalOptions = ((OptionRule)entry2.getValue()).getOptionalOptions();
            return ImmutableTriple.of(entry2.getKey(), requiredOptions, (Object)optionalOptions);
        }
        return ImmutableTriple.of(null, new ArrayList(), new ArrayList());
    }

    protected void getPluginsByFactoryIdentifier(LinkedHashMap<PluginIdentifier, OptionRule> plugins, PluginType pluginType, String factoryIdentifier, OptionRule optionRule) {
        PluginIdentifier pluginIdentifier = PluginIdentifier.of((String)"seatunnel", (String)pluginType.getType(), (String)factoryIdentifier);
        plugins.computeIfAbsent(pluginIdentifier, k -> optionRule);
    }

    public Map<PluginType, LinkedHashMap<PluginIdentifier, OptionRule>> getAllPlugin() {
        List<Factory> factories = this.getPluginFactories();
        HashMap<PluginType, LinkedHashMap<PluginIdentifier, OptionRule>> plugins = new HashMap<PluginType, LinkedHashMap<PluginIdentifier, OptionRule>>();
        factories.forEach(plugin -> {
            if (TableSourceFactory.class.isAssignableFrom(plugin.getClass())) {
                TableSourceFactory tableSourceFactory = (TableSourceFactory)plugin;
                plugins.computeIfAbsent(PluginType.SOURCE, k -> new LinkedHashMap());
                ((LinkedHashMap)plugins.get(PluginType.SOURCE)).put(PluginIdentifier.of((String)"seatunnel", (String)PluginType.SOURCE.getType(), (String)plugin.factoryIdentifier()), FactoryUtil.sourceFullOptionRule((TableSourceFactory)tableSourceFactory));
                return;
            }
            if (TableSinkFactory.class.isAssignableFrom(plugin.getClass())) {
                plugins.computeIfAbsent(PluginType.SINK, k -> new LinkedHashMap());
                ((LinkedHashMap)plugins.get(PluginType.SINK)).put(PluginIdentifier.of((String)"seatunnel", (String)PluginType.SINK.getType(), (String)plugin.factoryIdentifier()), FactoryUtil.sinkFullOptionRule((TableSinkFactory)((TableSinkFactory)plugin)));
                return;
            }
            if (TableTransformFactory.class.isAssignableFrom(plugin.getClass())) {
                plugins.computeIfAbsent(PluginType.TRANSFORM, k -> new LinkedHashMap());
                ((LinkedHashMap)plugins.get(PluginType.TRANSFORM)).put(PluginIdentifier.of((String)"seatunnel", (String)PluginType.TRANSFORM.getType(), (String)plugin.factoryIdentifier()), plugin.optionRule());
                return;
            }
        });
        return plugins;
    }

    protected List<Factory> getPluginFactories() {
        List factories;
        if (this.pluginDir.toFile().exists()) {
            List files;
            log.debug("load plugin from plugin dir: {}", (Object)this.pluginDir);
            try {
                files = FileUtils.searchJarFiles((Path)this.pluginDir);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Can not find any plugin(source/sink/transform) in the dir: %s", this.pluginDir));
            }
            factories = FactoryUtil.discoverFactories((ClassLoader)new URLClassLoader(files.toArray(new URL[0])));
        } else {
            log.warn("plugin dir: {} not exists, load plugin from classpath", (Object)this.pluginDir);
            factories = FactoryUtil.discoverFactories((ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        return factories;
    }

    protected T loadPluginInstance(PluginIdentifier pluginIdentifier, ClassLoader classLoader) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(this.getPluginBaseClass(), classLoader);
        for (T t : serviceLoader) {
            if (t instanceof PluginIdentifierInterface) {
                PluginIdentifierInterface pluginIdentifierInstance = (PluginIdentifierInterface)t;
                if (!StringUtils.equalsIgnoreCase((CharSequence)pluginIdentifierInstance.getPluginName(), (CharSequence)pluginIdentifier.getPluginName())) continue;
                return (T)pluginIdentifierInstance;
            }
            throw new UnsupportedOperationException("Plugin instance: " + t + " is not supported.");
        }
        return null;
    }

    protected Optional<List<URL>> getPluginJarPath(PluginIdentifier pluginIdentifier) {
        return this.pluginJarPath.computeIfAbsent(pluginIdentifier, this::findPluginJarPath);
    }

    protected abstract Class<T> getPluginBaseClass();

    private Optional<String> getPluginMappingPrefix(PluginIdentifier pluginIdentifier) {
        String engineType = pluginIdentifier.getEngineType().toLowerCase();
        String pluginType = pluginIdentifier.getPluginType().toLowerCase();
        String pluginName = pluginIdentifier.getPluginName().toLowerCase();
        if (!this.pluginMappingConfig.hasPath(engineType)) {
            return Optional.empty();
        }
        Config engineConfig = this.pluginMappingConfig.getConfig(engineType);
        if (!engineConfig.hasPath(pluginType)) {
            return Optional.empty();
        }
        Config typeConfig = engineConfig.getConfig(pluginType);
        Optional<Map.Entry> optional = typeConfig.entrySet().stream().filter(entry -> StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)pluginName)).findFirst();
        return optional.map(entry -> ((ConfigValue)entry.getValue()).unwrapped().toString());
    }

    private Optional<List<URL>> findPluginJarPath(PluginIdentifier pluginIdentifier) {
        List<URL> pluginJarPaths;
        Optional<String> pluginPrefix = this.getPluginMappingPrefix(pluginIdentifier);
        if (!pluginPrefix.isPresent()) {
            return Optional.empty();
        }
        String pluginName = pluginIdentifier.getPluginName().toLowerCase();
        String pluginType = pluginIdentifier.getPluginType().toLowerCase();
        Object[] targetPluginFiles = this.pluginDir.toFile().listFiles(pathname -> this.filterPluginJar(pathname, (String)pluginPrefix.get(), pluginName));
        if (ArrayUtils.isEmpty((Object[])targetPluginFiles)) {
            return Optional.empty();
        }
        PluginType type = PluginType.valueOf((String)pluginType.toUpperCase());
        try {
            pluginJarPaths = targetPluginFiles.length == 1 ? Collections.singletonList(((File)targetPluginFiles[0]).toURI().toURL()) : this.selectPluginJar((File[])targetPluginFiles, pluginPrefix.get(), pluginName, type).get();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        log.info("Discovery plugin jar for: {} at: {}", (Object)pluginIdentifier, pluginJarPaths);
        return Optional.of(pluginJarPaths);
    }

    private List<URL> getPluginDependencyJarPaths(PluginIdentifier pluginIdentifier) throws IOException {
        Optional<String> pluginPrefix = this.getPluginMappingPrefix(pluginIdentifier);
        if (!pluginPrefix.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<URL> jars = new ArrayList<URL>();
        Path pluginRootDir = Common.pluginRootDir();
        if (!Files.exists(pluginRootDir, new LinkOption[0]) || !Files.isDirectory(pluginRootDir, new LinkOption[0])) {
            return new ArrayList<URL>();
        }
        for (File file : pluginRootDir.toFile().listFiles()) {
            if (file.isDirectory() && (!file.getName().startsWith("connector-") || file.getName().equalsIgnoreCase(pluginPrefix.get()))) {
                jars.addAll(FileUtils.searchJarFiles((Path)Paths.get(Common.pluginRootDir().toString(), file.getName())));
                continue;
            }
            if (file.isDirectory()) continue;
            jars.add(file.toURI().toURL());
        }
        return jars.stream().filter(path -> path.toString().endsWith(".jar")).collect(Collectors.toList());
    }

    private boolean filterPluginJar(File pathname, String pluginJarPrefix, String pluginName) {
        if (pluginName.contains("cdc")) {
            return pathname.getName().endsWith(".jar") && (StringUtils.startsWithIgnoreCase((CharSequence)pathname.getName(), (CharSequence)pluginJarPrefix) || StringUtils.startsWithIgnoreCase((CharSequence)pathname.getName(), (CharSequence)"connector-cdc-base"));
        }
        return pathname.getName().endsWith(".jar") && StringUtils.startsWithIgnoreCase((CharSequence)pathname.getName(), (CharSequence)pluginJarPrefix);
    }

    private Optional<List<URL>> selectPluginJar(File[] targetPluginFiles, String pluginJarPrefix, String pluginName, PluginType type) {
        ArrayList resMatchedUrls = new ArrayList();
        for (File file : targetPluginFiles) {
            Optional<URL> matchedUrl = this.findMatchingUrl(file, type, pluginName);
            matchedUrl.ifPresent(resMatchedUrls::add);
        }
        if (pluginName.contains("cdc")) {
            if (resMatchedUrls.size() != 2) {
                throw new SeaTunnelException(String.format("Cannot find plugin jar for pluginIdentifier: %s -> %s. Possible impact jar: %s", pluginName, pluginJarPrefix, Arrays.asList(targetPluginFiles)));
            }
        } else if (resMatchedUrls.size() != 1) {
            throw new SeaTunnelException(String.format("Cannot find unique plugin jar for pluginIdentifier: %s -> %s. Possible impact jar: %s", pluginName, pluginJarPrefix, Arrays.asList(targetPluginFiles)));
        }
        return Optional.of(resMatchedUrls);
    }

    private Optional<URL> findMatchingUrl(File file, PluginType type, String pluginName) {
        Map<PluginIdentifier, String> pluginInstanceMap = null;
        switch (type) {
            case SINK: {
                pluginInstanceMap = this.sinkPluginInstance;
                break;
            }
            case SOURCE: {
                pluginInstanceMap = this.sourcePluginInstance;
                break;
            }
            case TRANSFORM: {
                pluginInstanceMap = this.transformPluginInstance;
            }
        }
        if (pluginInstanceMap == null) {
            return Optional.empty();
        }
        ArrayList<PluginIdentifier> matchedIdentifier = new ArrayList<PluginIdentifier>();
        for (Map.Entry<PluginIdentifier, String> entry : pluginInstanceMap.entrySet()) {
            if (!file.getName().startsWith(entry.getValue())) continue;
            matchedIdentifier.add(entry.getKey());
        }
        try {
            if (matchedIdentifier.size() == 1) {
                return Optional.of(file.toURI().toURL());
            }
            if (pluginName.contains("cdc") && file.getName().startsWith("connector-cdc-base")) {
                return Optional.of(file.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            log.warn("Cannot get plugin URL for pluginIdentifier: {}", (Object)file, (Object)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("File found: {}, matches more than one PluginIdentifier: {}", (Object)file.getName(), matchedIdentifier);
        }
        return Optional.empty();
    }
}

