/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;

public final class CacheSimpleEntryListenerConfigCodec {
    private static final int OLD_VALUE_REQUIRED_FIELD_OFFSET = 0;
    private static final int SYNCHRONOUS_FIELD_OFFSET = 1;
    private static final int INITIAL_FRAME_SIZE = 2;

    private CacheSimpleEntryListenerConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, CacheSimpleEntryListenerConfig cacheSimpleEntryListenerConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[2]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, cacheSimpleEntryListenerConfig.isOldValueRequired());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 1, cacheSimpleEntryListenerConfig.isSynchronous());
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, cacheSimpleEntryListenerConfig.getCacheEntryListenerFactory(), StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, cacheSimpleEntryListenerConfig.getCacheEntryEventFilterFactory(), StringCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static CacheSimpleEntryListenerConfig decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        boolean oldValueRequired = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        boolean synchronous = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 1);
        String cacheEntryListenerFactory = CodecUtil.decodeNullable(iterator2, StringCodec::decode);
        String cacheEntryEventFilterFactory = CodecUtil.decodeNullable(iterator2, StringCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return CustomTypeFactory.createCacheSimpleEntryListenerConfig(oldValueRequired, synchronous, cacheEntryListenerFactory, cacheEntryEventFilterFactory);
    }
}

