/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal;

import com.hazelcast.cp.CPGroup;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.exception.CPGroupDestroyedException;
import com.hazelcast.cp.internal.CPGroupSummary;
import com.hazelcast.cp.internal.CPMemberInfo;
import com.hazelcast.cp.internal.MembershipChangeSchedule;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftInvocationManager;
import com.hazelcast.cp.internal.RaftOp;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.operation.GetLeadedGroupsOp;
import com.hazelcast.cp.internal.operation.TransferLeadershipOp;
import com.hazelcast.cp.internal.raft.MembershipChangeMode;
import com.hazelcast.cp.internal.raft.QueryPolicy;
import com.hazelcast.cp.internal.raft.exception.MismatchingGroupMembersCommitIndexException;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.RaftNode;
import com.hazelcast.cp.internal.raft.impl.RaftNodeStatus;
import com.hazelcast.cp.internal.raftop.metadata.CompleteDestroyRaftGroupsOp;
import com.hazelcast.cp.internal.raftop.metadata.CompleteRaftGroupMembershipChangesOp;
import com.hazelcast.cp.internal.raftop.metadata.GetActiveCPMembersOp;
import com.hazelcast.cp.internal.raftop.metadata.GetActiveRaftGroupIdsOp;
import com.hazelcast.cp.internal.raftop.metadata.GetDestroyingRaftGroupIdsOp;
import com.hazelcast.cp.internal.raftop.metadata.GetMembershipChangeScheduleOp;
import com.hazelcast.cp.internal.raftop.metadata.GetRaftGroupOp;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class RaftGroupMembershipManager {
    static final long MANAGEMENT_TASK_PERIOD_IN_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    static final HazelcastProperty LEADERSHIP_BALANCE_TASK_PERIOD = new HazelcastProperty("hazelcast.raft.leadership.rebalance.period", 60);
    private static final long CHECK_LOCAL_RAFT_NODES_TASK_PERIOD = 10L;
    private final NodeEngine nodeEngine;
    private final RaftService raftService;
    private final ILogger logger;
    private final RaftInvocationManager invocationManager;
    private final AtomicBoolean initialized = new AtomicBoolean();

    RaftGroupMembershipManager(NodeEngine nodeEngine, RaftService raftService) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
        this.raftService = raftService;
        this.invocationManager = raftService.getInvocationManager();
    }

    void init() {
        if (this.raftService.getLocalCPMember() == null || !this.initialized.compareAndSet(false, true)) {
            return;
        }
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        executionService.scheduleWithRepetition("hz:cpSubsystemManagement", new RaftGroupDestroyHandlerTask(), MANAGEMENT_TASK_PERIOD_IN_MILLIS, MANAGEMENT_TASK_PERIOD_IN_MILLIS, TimeUnit.MILLISECONDS);
        executionService.scheduleWithRepetition("hz:cpSubsystemManagement", new RaftGroupMembershipChangeHandlerTask(), MANAGEMENT_TASK_PERIOD_IN_MILLIS, MANAGEMENT_TASK_PERIOD_IN_MILLIS, TimeUnit.MILLISECONDS);
        executionService.scheduleWithRepetition("hz:cpSubsystemManagement", new CheckLocalRaftNodesTask(), 10L, 10L, TimeUnit.SECONDS);
        int leadershipRebalancePeriod = this.nodeEngine.getProperties().getInteger(LEADERSHIP_BALANCE_TASK_PERIOD);
        executionService.scheduleWithRepetition("hz:cpSubsystemManagement", new RaftGroupLeadershipBalanceTask(), leadershipRebalancePeriod, leadershipRebalancePeriod, TimeUnit.SECONDS);
    }

    private boolean skipRunningTask() {
        return !this.raftService.isDiscoveryCompleted() || !this.raftService.isStartCompleted() || !this.raftService.getMetadataGroupManager().isMetadataGroupLeader();
    }

    void rebalanceGroupLeaderships() {
        new RaftGroupLeadershipBalanceTask().run();
    }

    private <T> InternalCompletableFuture<T> queryMetadata(RaftOp op) {
        return this.invocationManager.query(this.raftService.getMetadataGroupId(), op, QueryPolicy.LEADER_LOCAL);
    }

    private final class RaftGroupLeadershipBalanceTask
    implements Runnable {
        private RaftGroupLeadershipBalanceTask() {
        }

        @Override
        public void run() {
            if (RaftGroupMembershipManager.this.skipRunningTask()) {
                return;
            }
            try {
                this.rebalanceLeaderships();
            }
            catch (Exception e) {
                if (RaftGroupMembershipManager.this.logger.isFineEnabled()) {
                    RaftGroupMembershipManager.this.logger.warning("Cannot execute leadership rebalance at the moment", e);
                }
                RaftGroupMembershipManager.this.logger.info("Cannot execute leadership rebalance at the moment: " + e.getClass().getName() + ": " + e.getMessage());
            }
        }

        private void rebalanceLeaderships() {
            Map<RaftEndpoint, CPMember> members = this.getMembers();
            Collection<CPGroupId> groupIds = this.getCpGroupIds();
            int avgGroupsPerMember = groupIds.size() / members.size();
            boolean overAvgAllowed = groupIds.size() % members.size() != 0;
            ArrayList<CPGroupSummary> allGroups = new ArrayList<CPGroupSummary>(groupIds.size());
            for (CPGroupId groupId : groupIds) {
                CPGroupSummary group = this.getCpGroup(groupId);
                allGroups.add(group);
            }
            RaftGroupMembershipManager.this.logger.fine("Searching for leadership imbalance in " + groupIds.size() + " CPGroups, average groups per member is " + avgGroupsPerMember);
            HashSet<CPMember> handledMembers = new HashSet<CPMember>(members.size());
            Map<CPMember, Collection<CPGroupId>> leaderships = this.getLeadershipsMap(members);
            while (true) {
                BiTuple<CPMember, Integer> from2 = this.getEndpointWithMaxLeaderships(leaderships, avgGroupsPerMember, handledMembers);
                if (from2.element1 == null) {
                    RaftGroupMembershipManager.this.logger.info("CPGroup leadership balance is fine, cannot rebalance further...");
                    return;
                }
                RaftGroupMembershipManager.this.logger.info("Searching a candidate transfer leadership from " + from2.element1 + " with " + from2.element2 + " leaderships.");
                Collection<CPGroupSummary> groups = this.getLeaderGroupsOf((CPMember)from2.element1, leaderships.get(from2.element1), allGroups);
                int maxLeaderships = overAvgAllowed ? ((Integer)from2.element2 > avgGroupsPerMember + 1 ? avgGroupsPerMember : avgGroupsPerMember - 1) : avgGroupsPerMember;
                BiTuple<CPMember, CPGroupId> to2 = this.getEndpointWithMinLeaderships(groups, leaderships, maxLeaderships);
                if (to2.element1 == null) {
                    RaftGroupMembershipManager.this.logger.info("No candidate could be found to get leadership from " + from2.element1 + ". Skipping to next...");
                    handledMembers.add((CPMember)from2.element1);
                    continue;
                }
                if (!this.transferLeadership((CPMember)from2.element1, (CPMember)to2.element1, (CPGroupId)to2.element2)) {
                    return;
                }
                leaderships = this.getLeadershipsMap(members);
            }
        }

        private Map<CPMember, Collection<CPGroupId>> getLeadershipsMap(Map<RaftEndpoint, CPMember> members) {
            HashMap<CPMember, Collection<CPGroupId>> leaderships = new HashMap<CPMember, Collection<CPGroupId>>();
            OperationService operationService = RaftGroupMembershipManager.this.nodeEngine.getOperationService();
            StringBuilder s2 = new StringBuilder("Current leadership claims:");
            for (CPMember member : members.values()) {
                Collection groups = (Collection)operationService.invokeOnTarget(null, new GetLeadedGroupsOp(), member.getAddress()).join();
                leaderships.put(member, groups);
                if (RaftGroupMembershipManager.this.logger.isFineEnabled()) {
                    RaftGroupMembershipManager.this.logger.fine(member + " claims it's leader of " + groups.size() + " groups: " + groups);
                }
                s2.append('\n').append('\t').append(member).append(" has ").append(groups.size()).append(",");
            }
            s2.setLength(s2.length() - 1);
            s2.append(" leaderships.");
            RaftGroupMembershipManager.this.logger.info(s2.toString());
            return leaderships;
        }

        private Collection<CPGroupSummary> getLeaderGroupsOf(CPMember member, Collection<CPGroupId> leaderships, Collection<CPGroupSummary> groups) {
            ArrayList<CPGroupSummary> memberGroups = new ArrayList<CPGroupSummary>();
            for (CPGroupSummary group : groups) {
                if ("METADATA".equals(group.id().getName()) || !leaderships.contains(group.id()) || !group.members().contains(member)) continue;
                memberGroups.add(group);
            }
            return memberGroups;
        }

        private BiTuple<CPMember, CPGroupId> getEndpointWithMinLeaderships(Collection<CPGroupSummary> groups, Map<CPMember, Collection<CPGroupId>> leaderships, int maxLeaderships) {
            CPMember to2 = null;
            CPGroupId groupId = null;
            int min2 = maxLeaderships;
            for (CPGroupSummary group : groups) {
                for (CPMember member : group.members()) {
                    Collection<CPGroupId> g2 = leaderships.get(member);
                    int k = g2 != null ? g2.size() : 0;
                    if (k >= min2) continue;
                    min2 = k;
                    to2 = member;
                    groupId = group.id();
                }
            }
            return BiTuple.of(to2, groupId);
        }

        private BiTuple<CPMember, Integer> getEndpointWithMaxLeaderships(Map<CPMember, Collection<CPGroupId>> leaderships, int minLeaderships, Set<CPMember> excludeSet) {
            CPMember from2 = null;
            int max2 = minLeaderships;
            for (Map.Entry<CPMember, Collection<CPGroupId>> entry : leaderships.entrySet()) {
                int count2;
                if (excludeSet.contains(entry.getKey()) || (count2 = entry.getValue().size()) <= max2) continue;
                from2 = entry.getKey();
                max2 = count2;
            }
            return BiTuple.of(from2, max2);
        }

        private boolean transferLeadership(CPMember from2, CPMember to2, CPGroupId groupId) {
            RaftGroupMembershipManager.this.logger.info("Transferring leadership from " + from2 + " to " + to2 + " in " + groupId);
            try {
                RaftGroupMembershipManager.this.nodeEngine.getOperationService().invokeOnTarget(null, new TransferLeadershipOp(groupId, to2), from2.getAddress()).join();
                return true;
            }
            catch (Exception e) {
                RaftGroupMembershipManager.this.logger.warning(e);
                return false;
            }
        }

        private Map<RaftEndpoint, CPMember> getMembers() {
            InternalCompletableFuture future = RaftGroupMembershipManager.this.queryMetadata(new GetActiveCPMembersOp());
            Collection members = (Collection)future.join();
            HashMap<RaftEndpoint, CPMember> map2 = new HashMap<RaftEndpoint, CPMember>(members.size());
            for (CPMemberInfo member : members) {
                map2.put(member.toRaftEndpoint(), member);
            }
            return map2;
        }

        private CPGroupSummary getCpGroup(CPGroupId groupId) {
            InternalCompletableFuture f = RaftGroupMembershipManager.this.queryMetadata(new GetRaftGroupOp(groupId));
            return (CPGroupSummary)f.join();
        }

        private Collection<CPGroupId> getCpGroupIds() {
            InternalCompletableFuture future = RaftGroupMembershipManager.this.queryMetadata(new GetActiveRaftGroupIdsOp());
            Collection groupIds = (Collection)future.join();
            groupIds.remove(RaftGroupMembershipManager.this.raftService.getMetadataGroupId());
            return groupIds;
        }
    }

    private class RaftGroupMembershipChangeHandlerTask
    implements Runnable {
        private static final int NA_MEMBERS_COMMIT_INDEX = -1;

        private RaftGroupMembershipChangeHandlerTask() {
        }

        @Override
        public void run() {
            if (RaftGroupMembershipManager.this.skipRunningTask()) {
                return;
            }
            MembershipChangeSchedule schedule = this.getMembershipChangeSchedule();
            if (schedule == null) {
                return;
            }
            if (RaftGroupMembershipManager.this.logger.isFineEnabled()) {
                RaftGroupMembershipManager.this.logger.fine("Handling " + schedule);
            }
            List<MembershipChangeSchedule.CPGroupMembershipChange> changes = schedule.getChanges();
            CountDownLatch latch = new CountDownLatch(changes.size());
            ConcurrentHashMap<CPGroupId, BiTuple<Long, Long>> changedGroups = new ConcurrentHashMap<CPGroupId, BiTuple<Long, Long>>();
            for (MembershipChangeSchedule.CPGroupMembershipChange change : changes) {
                this.applyOnRaftGroup(latch, changedGroups, change);
            }
            try {
                latch.await();
                this.completeMembershipChanges(changedGroups);
            }
            catch (InterruptedException e) {
                RaftGroupMembershipManager.this.logger.warning("Membership changes interrupted while executing " + schedule + ". completed: " + changedGroups, e);
                Thread.currentThread().interrupt();
            }
        }

        private MembershipChangeSchedule getMembershipChangeSchedule() {
            InternalCompletableFuture f = RaftGroupMembershipManager.this.queryMetadata(new GetMembershipChangeScheduleOp());
            return (MembershipChangeSchedule)f.joinInternal();
        }

        private void applyOnRaftGroup(CountDownLatch latch, Map<CPGroupId, BiTuple<Long, Long>> changedGroups, MembershipChangeSchedule.CPGroupMembershipChange change) {
            CompletableFuture future = change.getMemberToRemove() != null ? RaftGroupMembershipManager.this.invocationManager.changeMembership(change.getGroupId(), change.getMembersCommitIndex(), change.getMemberToRemove(), MembershipChangeMode.REMOVE) : CompletableFuture.completedFuture(change.getMembersCommitIndex());
            future.whenCompleteAsync((removeCommitIndex, t) -> {
                if (t == null) {
                    if (change.getMemberToAdd() != null) {
                        this.addMember(latch, changedGroups, change, (long)removeCommitIndex);
                    } else {
                        changedGroups.put(change.getGroupId(), BiTuple.of(change.getMembersCommitIndex(), removeCommitIndex));
                        latch.countDown();
                    }
                } else {
                    long commitIndex = this.checkMemberRemoveCommitIndex(changedGroups, change, (Throwable)t);
                    if (commitIndex != -1L) {
                        if (change.getMemberToAdd() != null) {
                            this.addMember(latch, changedGroups, change, commitIndex);
                        } else {
                            changedGroups.put(change.getGroupId(), BiTuple.of(change.getMembersCommitIndex(), commitIndex));
                            latch.countDown();
                        }
                    } else {
                        latch.countDown();
                    }
                }
            });
        }

        private void addMember(CountDownLatch latch, Map<CPGroupId, BiTuple<Long, Long>> changedGroups, MembershipChangeSchedule.CPGroupMembershipChange change, long currentCommitIndex) {
            InternalCompletableFuture future = RaftGroupMembershipManager.this.invocationManager.changeMembership(change.getGroupId(), currentCommitIndex, change.getMemberToAdd(), MembershipChangeMode.ADD);
            ((CompletableFuture)future).whenCompleteAsync((addCommitIndex, t) -> {
                if (t == null) {
                    changedGroups.put(change.getGroupId(), BiTuple.of(change.getMembersCommitIndex(), addCommitIndex));
                    latch.countDown();
                } else {
                    this.checkMemberAddCommitIndex(changedGroups, change, (Throwable)t);
                    latch.countDown();
                }
            });
        }

        private void checkMemberAddCommitIndex(Map<CPGroupId, BiTuple<Long, Long>> changedGroups, MembershipChangeSchedule.CPGroupMembershipChange change, Throwable t) {
            RaftEndpoint memberToAdd = change.getMemberToAdd();
            if (t instanceof MismatchingGroupMembersCommitIndexException) {
                MismatchingGroupMembersCommitIndexException m3 = (MismatchingGroupMembersCommitIndexException)t;
                String msg = "MEMBER ADD commit of " + change + " failed. Actual group members: " + m3.getMembers() + " with commit index: " + m3.getCommitIndex();
                if (!m3.getMembers().contains(memberToAdd)) {
                    RaftGroupMembershipManager.this.logger.severe(msg);
                    return;
                }
                if (change.getMemberToRemove() != null) {
                    if (m3.getMembers().contains(change.getMemberToRemove())) {
                        RaftGroupMembershipManager.this.logger.severe(msg);
                        return;
                    }
                    if (m3.getMembers().size() != change.getMembers().size()) {
                        RaftGroupMembershipManager.this.logger.severe(msg);
                        return;
                    }
                } else if (m3.getMembers().size() != change.getMembers().size() + 1) {
                    RaftGroupMembershipManager.this.logger.severe(msg);
                    return;
                }
                for (RaftEndpoint member : change.getMembers()) {
                    if (member.equals(change.getMemberToRemove()) || m3.getMembers().contains(member)) continue;
                    RaftGroupMembershipManager.this.logger.severe(msg);
                    return;
                }
                changedGroups.put(change.getGroupId(), BiTuple.of(change.getMembersCommitIndex(), m3.getCommitIndex()));
                return;
            }
            RaftGroupMembershipManager.this.logger.severe("Cannot get MEMBER ADD result of " + memberToAdd + " to " + change.getGroupId() + " with members commit index: " + change.getMembersCommitIndex(), t);
        }

        private long checkMemberRemoveCommitIndex(Map<CPGroupId, BiTuple<Long, Long>> changedGroups, MembershipChangeSchedule.CPGroupMembershipChange change, Throwable t) {
            RaftEndpoint removedMember = change.getMemberToRemove();
            if (t instanceof MismatchingGroupMembersCommitIndexException) {
                MismatchingGroupMembersCommitIndexException m3 = (MismatchingGroupMembersCommitIndexException)t;
                String msg = "MEMBER REMOVE commit of " + change + " failed. Actual group members: " + m3.getMembers() + " with commit index: " + m3.getCommitIndex();
                if (m3.getMembers().contains(removedMember)) {
                    RaftGroupMembershipManager.this.logger.severe(msg);
                    return -1L;
                }
                if (change.getMemberToAdd() != null && m3.getMembers().contains(change.getMemberToAdd())) {
                    if (m3.getMembers().size() != change.getMembers().size()) {
                        RaftGroupMembershipManager.this.logger.severe(msg);
                        return -1L;
                    }
                    for (RaftEndpoint member : change.getMembers()) {
                        if (member.equals(removedMember) || m3.getMembers().contains(member)) continue;
                        RaftGroupMembershipManager.this.logger.severe(msg);
                        return -1L;
                    }
                    changedGroups.put(change.getGroupId(), BiTuple.of(change.getMembersCommitIndex(), m3.getCommitIndex()));
                    return -1L;
                }
                if (m3.getMembers().size() != change.getMembers().size() - 1) {
                    RaftGroupMembershipManager.this.logger.severe(msg);
                    return -1L;
                }
                for (RaftEndpoint member : change.getMembers()) {
                    if (member.equals(removedMember) || m3.getMembers().contains(member)) continue;
                    RaftGroupMembershipManager.this.logger.severe(msg);
                    return -1L;
                }
                return m3.getCommitIndex();
            }
            RaftGroupMembershipManager.this.logger.severe("Cannot get MEMBER REMOVE result of " + removedMember + " to " + change.getGroupId(), t);
            return -1L;
        }

        private void completeMembershipChanges(Map<CPGroupId, BiTuple<Long, Long>> changedGroups) {
            CompleteRaftGroupMembershipChangesOp op = new CompleteRaftGroupMembershipChangesOp(changedGroups);
            RaftGroupId metadataGroupId = RaftGroupMembershipManager.this.raftService.getMetadataGroupId();
            InternalCompletableFuture future = RaftGroupMembershipManager.this.invocationManager.invoke(metadataGroupId, op);
            try {
                future.get();
            }
            catch (Exception e) {
                RaftGroupMembershipManager.this.logger.severe("Cannot commit CP group membership changes: " + changedGroups, e);
            }
        }
    }

    private class RaftGroupDestroyHandlerTask
    implements Runnable {
        private RaftGroupDestroyHandlerTask() {
        }

        @Override
        public void run() {
            if (RaftGroupMembershipManager.this.skipRunningTask()) {
                return;
            }
            Set<CPGroupId> destroyedGroupIds = this.destroyRaftGroups();
            if (destroyedGroupIds.isEmpty()) {
                return;
            }
            this.commitDestroyedRaftGroups(destroyedGroupIds);
        }

        private Set<CPGroupId> destroyRaftGroups() {
            Collection<CPGroupId> destroyingRaftGroupIds = this.getDestroyingRaftGroupIds();
            if (destroyingRaftGroupIds.isEmpty()) {
                return Collections.emptySet();
            }
            HashMap<CPGroupId, InternalCompletableFuture<Object>> futures = new HashMap<CPGroupId, InternalCompletableFuture<Object>>();
            for (CPGroupId groupId : destroyingRaftGroupIds) {
                InternalCompletableFuture<Object> future = RaftGroupMembershipManager.this.invocationManager.destroy(groupId);
                futures.put(groupId, future);
            }
            HashSet<CPGroupId> destroyedGroupIds = new HashSet<CPGroupId>();
            for (Map.Entry e : futures.entrySet()) {
                if (!this.isRaftGroupDestroyed((CPGroupId)e.getKey(), (Future)e.getValue())) continue;
                destroyedGroupIds.add((CPGroupId)e.getKey());
            }
            return destroyedGroupIds;
        }

        private Collection<CPGroupId> getDestroyingRaftGroupIds() {
            InternalCompletableFuture f = RaftGroupMembershipManager.this.queryMetadata(new GetDestroyingRaftGroupIdsOp());
            return (Collection)f.joinInternal();
        }

        private boolean isRaftGroupDestroyed(CPGroupId groupId, Future<Object> future) {
            try {
                future.get();
                return true;
            }
            catch (InterruptedException e) {
                RaftGroupMembershipManager.this.logger.severe("Cannot get result of DESTROY commit to " + groupId, e);
                return false;
            }
            catch (ExecutionException e) {
                if (ExceptionUtil.peel(e) instanceof CPGroupDestroyedException) {
                    return true;
                }
                RaftGroupMembershipManager.this.logger.severe("Cannot get result of DESTROY commit to " + groupId, e);
                return false;
            }
        }

        private void commitDestroyedRaftGroups(Set<CPGroupId> destroyedGroupIds) {
            CompleteDestroyRaftGroupsOp op = new CompleteDestroyRaftGroupsOp(destroyedGroupIds);
            RaftGroupId metadataGroupId = RaftGroupMembershipManager.this.raftService.getMetadataGroupId();
            InternalCompletableFuture f = RaftGroupMembershipManager.this.invocationManager.invoke(metadataGroupId, op);
            try {
                f.get();
                RaftGroupMembershipManager.this.logger.info("Terminated CP groups: " + destroyedGroupIds + " are committed.");
            }
            catch (Exception e) {
                RaftGroupMembershipManager.this.logger.severe("Cannot commit terminated CP groups: " + destroyedGroupIds, e);
            }
        }
    }

    private class CheckLocalRaftNodesTask
    implements Runnable {
        private CheckLocalRaftNodesTask() {
        }

        @Override
        public void run() {
            if (!RaftGroupMembershipManager.this.raftService.isDiscoveryCompleted() || !RaftGroupMembershipManager.this.raftService.isStartCompleted()) {
                return;
            }
            for (RaftNode raftNode : RaftGroupMembershipManager.this.raftService.getAllRaftNodes()) {
                CPGroupId groupId = raftNode.getGroupId();
                if (groupId.equals(RaftGroupMembershipManager.this.raftService.getMetadataGroupId())) continue;
                if (raftNode.getStatus() == RaftNodeStatus.TERMINATED) {
                    RaftGroupMembershipManager.this.raftService.terminateRaftNode(groupId, false);
                    continue;
                }
                if (raftNode.getStatus() == RaftNodeStatus.STEPPED_DOWN) {
                    RaftGroupMembershipManager.this.raftService.stepDownRaftNode(groupId);
                    continue;
                }
                InternalCompletableFuture f = RaftGroupMembershipManager.this.queryMetadata(new GetRaftGroupOp(groupId));
                ((CompletableFuture)f).whenCompleteAsync((group, t) -> {
                    if (t == null) {
                        if (group == null) {
                            RaftGroupMembershipManager.this.logger.severe("Could not find CP group for local raft node of " + groupId);
                        } else if (group.status() == CPGroup.CPGroupStatus.DESTROYED) {
                            RaftGroupMembershipManager.this.raftService.terminateRaftNode(groupId, true);
                        }
                    } else {
                        RaftGroupMembershipManager.this.logger.warning("Could not get CP group info of " + groupId, (Throwable)t);
                    }
                });
            }
        }
    }
}

