/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.semaphore;

import com.hazelcast.config.cp.SemaphoreConfig;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.ISemaphore;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.datastructures.exception.WaitKeyCancelledException;
import com.hazelcast.cp.internal.datastructures.semaphore.AcquireInvocationKey;
import com.hazelcast.cp.internal.datastructures.semaphore.AcquireResult;
import com.hazelcast.cp.internal.datastructures.semaphore.ReleaseResult;
import com.hazelcast.cp.internal.datastructures.semaphore.Semaphore;
import com.hazelcast.cp.internal.datastructures.semaphore.SemaphoreEndpoint;
import com.hazelcast.cp.internal.datastructures.semaphore.SemaphoreRegistry;
import com.hazelcast.cp.internal.datastructures.semaphore.proxy.SessionAwareSemaphoreProxy;
import com.hazelcast.cp.internal.datastructures.semaphore.proxy.SessionlessSemaphoreProxy;
import com.hazelcast.cp.internal.datastructures.spi.blocking.AbstractBlockingService;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.Collection;
import java.util.UUID;

public class SemaphoreService
extends AbstractBlockingService<AcquireInvocationKey, Semaphore, SemaphoreRegistry>
implements DynamicMetricsProvider {
    public static final String SERVICE_NAME = "hz:raft:semaphoreService";

    public SemaphoreService(NodeEngine nodeEngine) {
        super(nodeEngine);
    }

    @Override
    protected void initImpl() {
        super.initImpl();
        this.nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(this);
    }

    public boolean initSemaphore(CPGroupId groupId, String name, int permits) {
        try {
            Collection<AcquireInvocationKey> acquired = ((SemaphoreRegistry)this.getOrInitRegistry(groupId)).init(name, permits);
            this.notifyWaitKeys(groupId, name, acquired, true);
            return true;
        }
        catch (IllegalStateException ignored) {
            return false;
        }
    }

    private SemaphoreConfig getConfig(String name) {
        return this.nodeEngine.getConfig().getCPSubsystemConfig().findSemaphoreConfig(name);
    }

    public int availablePermits(CPGroupId groupId, String name) {
        SemaphoreRegistry registry = (SemaphoreRegistry)this.getOrInitRegistry(groupId);
        return registry != null ? registry.availablePermits(name) : 0;
    }

    public AcquireResult acquirePermits(CPGroupId groupId, String name, AcquireInvocationKey key, long timeoutMs) {
        this.heartbeatSession(groupId, key.sessionId());
        AcquireResult result2 = ((SemaphoreRegistry)this.getOrInitRegistry(groupId)).acquire(name, key, timeoutMs);
        if (this.logger.isFineEnabled()) {
            if (result2.status() == AcquireResult.AcquireStatus.SUCCESSFUL) {
                this.logger.fine("Semaphore[" + name + "] in " + groupId + " acquired permits: " + key.permits() + " by <" + key.endpoint() + ", " + key.invocationUid() + "> at commit index: " + key.commitIndex());
            } else if (result2.status() == AcquireResult.AcquireStatus.WAIT_KEY_ADDED) {
                this.logger.fine("Semaphore[" + name + "] in " + groupId + " wait key added for permits: " + key.permits() + " by <" + key.endpoint() + ", " + key.invocationUid() + "> at commit index: " + key.commitIndex());
            } else if (result2.status() == AcquireResult.AcquireStatus.FAILED) {
                this.logger.fine("Semaphore[" + name + "] in " + groupId + " not acquired permits: " + key.permits() + " by <" + key.endpoint() + ", " + key.invocationUid() + "> at commit index: " + key.commitIndex());
            }
        }
        this.notifyCancelledWaitKeys(groupId, name, result2.cancelledWaitKeys());
        if (result2.status() == AcquireResult.AcquireStatus.WAIT_KEY_ADDED) {
            this.scheduleTimeout(groupId, name, key.invocationUid(), timeoutMs);
        }
        return result2;
    }

    public void releasePermits(CPGroupId groupId, long commitIndex, String name, SemaphoreEndpoint endpoint, UUID invocationUid, int permits) {
        this.heartbeatSession(groupId, endpoint.sessionId());
        ReleaseResult result2 = ((SemaphoreRegistry)this.getOrInitRegistry(groupId)).release(name, endpoint, invocationUid, permits);
        this.notifyCancelledWaitKeys(groupId, name, result2.cancelledWaitKeys());
        this.notifyWaitKeys(groupId, name, result2.acquiredWaitKeys(), true);
        if (this.logger.isFineEnabled()) {
            if (result2.success()) {
                this.logger.fine("Semaphore[" + name + "] in " + groupId + " released permits: " + permits + " by <" + endpoint + ", " + invocationUid + "> at commit index: " + commitIndex + " new acquires: " + result2.acquiredWaitKeys());
            } else {
                this.logger.fine("Semaphore[" + name + "] in " + groupId + " not-released permits: " + permits + " by <" + endpoint + ", " + invocationUid + "> at commit index: " + commitIndex);
            }
        }
        if (!result2.success()) {
            throw new IllegalStateException("Could not release " + permits + " permits in Semaphore[" + name + "] because the caller has acquired less than " + permits + " permits");
        }
    }

    public int drainPermits(CPGroupId groupId, String name, long commitIndex, SemaphoreEndpoint endpoint, UUID invocationUid) {
        this.heartbeatSession(groupId, endpoint.sessionId());
        AcquireResult result2 = ((SemaphoreRegistry)this.getOrInitRegistry(groupId)).drainPermits(name, endpoint, invocationUid);
        this.notifyCancelledWaitKeys(groupId, name, result2.cancelledWaitKeys());
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Semaphore[" + name + "] in " + groupId + " drained permits: " + result2.permits() + " by <" + endpoint + ", " + invocationUid + "> at commit index: " + commitIndex);
        }
        return result2.permits();
    }

    public boolean changePermits(CPGroupId groupId, long commitIndex, String name, SemaphoreEndpoint endpoint, UUID invocationUid, int permits) {
        this.heartbeatSession(groupId, endpoint.sessionId());
        ReleaseResult result2 = ((SemaphoreRegistry)this.getOrInitRegistry(groupId)).changePermits(name, endpoint, invocationUid, permits);
        this.notifyCancelledWaitKeys(groupId, name, result2.cancelledWaitKeys());
        this.notifyWaitKeys(groupId, name, result2.acquiredWaitKeys(), true);
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Semaphore[" + name + "] in " + groupId + " changed permits: " + permits + " by <" + endpoint + ", " + invocationUid + "> at commit index: " + commitIndex + ". new acquires: " + result2.acquiredWaitKeys());
        }
        return result2.success();
    }

    private void notifyCancelledWaitKeys(CPGroupId groupId, String name, Collection<AcquireInvocationKey> keys) {
        if (keys.isEmpty()) {
            return;
        }
        this.notifyWaitKeys(groupId, name, keys, new WaitKeyCancelledException());
    }

    @Override
    protected SemaphoreRegistry createNewRegistry(CPGroupId groupId) {
        return new SemaphoreRegistry(groupId, this.raftService.getConfig());
    }

    @Override
    protected void onRegistryRestored(SemaphoreRegistry registry) {
        registry.setCpSubsystemConfig(this.raftService.getConfig());
    }

    @Override
    protected Object expiredWaitKeyResponse() {
        return false;
    }

    @Override
    protected String serviceName() {
        return SERVICE_NAME;
    }

    public ISemaphore createProxy(String proxyName) {
        try {
            proxyName = RaftService.withoutDefaultGroupName(proxyName);
            RaftGroupId groupId = this.raftService.createRaftGroupForProxy(proxyName);
            String objectName = RaftService.getObjectNameForProxy(proxyName);
            SemaphoreConfig config = this.getConfig(proxyName);
            return config != null && config.isJDKCompatible() ? new SessionlessSemaphoreProxy(this.nodeEngine, groupId, proxyName, objectName) : new SessionAwareSemaphoreProxy(this.nodeEngine, groupId, proxyName, objectName);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        MetricDescriptor root = descriptor.withPrefix("cp.semaphore");
        for (CPGroupId groupId : this.getGroupIdSet()) {
            SemaphoreRegistry registry = (SemaphoreRegistry)this.getRegistryOrNull(groupId);
            for (Semaphore sema : registry.getAllSemaphores()) {
                MetricDescriptor desc = root.copy().withDiscriminator("id", sema.getName() + "@" + groupId.getName()).withTag("name", sema.getName()).withTag("group", groupId.getName());
                context.collect(desc.copy().withMetric("initialized"), sema.isInitialized() ? 1L : 0L);
                context.collect(desc.copy().withUnit(ProbeUnit.COUNT).withMetric("available"), sema.getAvailable());
            }
        }
    }
}

