/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.merge;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.merge.SplitBrainDataSerializerHook;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import java.io.IOException;
import java.util.Objects;

public class CacheMergingEntryImpl<K, V>
implements SplitBrainMergeTypes.CacheMergeTypes<K, V>,
SerializationServiceAware,
IdentifiedDataSerializable {
    private Data value;
    private Data key;
    private long creationTime = -1L;
    private long expirationTime = -1L;
    private long hits = -1L;
    private long lastAccessTime = -1L;
    private transient SerializationService serializationService;

    public CacheMergingEntryImpl() {
    }

    public CacheMergingEntryImpl(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    @Override
    public Data getRawValue() {
        return this.value;
    }

    @Override
    public V getValue() {
        return (V)this.serializationService.toObject(this.value);
    }

    public CacheMergingEntryImpl<K, V> setValue(Data value) {
        this.value = value;
        return this;
    }

    @Override
    public Data getRawKey() {
        return this.key;
    }

    @Override
    public K getKey() {
        return (K)this.serializationService.toObject(this.key);
    }

    public CacheMergingEntryImpl<K, V> setKey(Data key) {
        this.key = key;
        return this;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    public CacheMergingEntryImpl<K, V> setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    public CacheMergingEntryImpl<K, V> setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    public CacheMergingEntryImpl<K, V> setHits(long hits) {
        this.hits = hits;
        return this;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public CacheMergingEntryImpl<K, V> setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        return this;
    }

    @Override
    public void setSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        IOUtil.writeObject(out, this.key);
        IOUtil.writeObject(out, this.value);
        out.writeLong(this.creationTime);
        out.writeLong(this.expirationTime);
        out.writeLong(this.hits);
        out.writeLong(this.lastAccessTime);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = (Data)IOUtil.readObject(in);
        this.value = (Data)IOUtil.readObject(in);
        this.creationTime = in.readLong();
        this.expirationTime = in.readLong();
        this.hits = in.readLong();
        this.lastAccessTime = in.readLong();
    }

    @Override
    public int getFactoryId() {
        return SplitBrainDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheMergingEntryImpl that = (CacheMergingEntryImpl)o;
        if (this.creationTime != that.creationTime) {
            return false;
        }
        if (this.expirationTime != that.expirationTime) {
            return false;
        }
        if (this.hits != that.hits) {
            return false;
        }
        if (this.lastAccessTime != that.lastAccessTime) {
            return false;
        }
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result2 = this.key != null ? this.key.hashCode() : 0;
        result2 = 31 * result2 + (this.value != null ? this.value.hashCode() : 0);
        result2 = 31 * result2 + (int)(this.creationTime ^ this.creationTime >>> 32);
        result2 = 31 * result2 + (int)(this.expirationTime ^ this.expirationTime >>> 32);
        result2 = 31 * result2 + (int)(this.hits ^ this.hits >>> 32);
        result2 = 31 * result2 + (int)(this.lastAccessTime ^ this.lastAccessTime >>> 32);
        return result2;
    }

    public String toString() {
        return "CacheMergingEntry{key=" + this.key + ", value=" + this.value + ", creationTime=" + this.creationTime + ", expirationTime=" + this.expirationTime + ", hits=" + this.hits + ", lastAccessTime=" + this.lastAccessTime + '}';
    }
}

