/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint;

import com.google.common.base.Preconditions;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.map.IMap;
import java.util.concurrent.CompletableFuture;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.core.checkpoint.CheckpointIDCounter;
import org.apache.seatunnel.engine.core.job.PipelineStatus;

public class IMapCheckpointIDCounter
implements CheckpointIDCounter {
    private final Integer pipelineId;
    private final IMap<Integer, Long> checkpointIdMap;

    public IMapCheckpointIDCounter(Integer pipelineId, IMap<Integer, Long> checkpointIdMap) {
        this.pipelineId = pipelineId;
        this.checkpointIdMap = checkpointIdMap;
    }

    @Override
    public void start() throws Exception {
        RetryUtils.retryWithException(() -> this.checkpointIdMap.putIfAbsent(this.pipelineId, 1L), new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof HazelcastInstanceNotActiveException, 2000L));
    }

    @Override
    public CompletableFuture<Void> shutdown(PipelineStatus pipelineStatus) {
        if (pipelineStatus.isEndState()) {
            this.checkpointIdMap.remove(this.pipelineId);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public long getAndIncrement() throws Exception {
        Long nextId = this.checkpointIdMap.compute(this.pipelineId, (k, v) -> v == null ? null : Long.valueOf(v + 1L));
        Preconditions.checkNotNull(nextId);
        return nextId - 1L;
    }

    @Override
    public long get() {
        return this.checkpointIdMap.get(this.pipelineId);
    }

    @Override
    public void setCount(long newId) throws Exception {
        this.checkpointIdMap.put(this.pipelineId, newId);
    }
}

