/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.CommonOptions;
import org.apache.seatunnel.api.table.type.MetadataUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowAccessor;
import org.apache.seatunnel.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.seatunnel.transform.common.MultipleFieldOutputTransform;
import org.apache.seatunnel.transform.exception.TransformCommonError;
import org.apache.seatunnel.transform.metadata.MetadataTransformConfig;

public class MetadataTransform
extends MultipleFieldOutputTransform {
    private List<String> fieldNames;
    private Map<String, String> metadataFieldMapping;

    public MetadataTransform(ReadonlyConfig config, @NonNull CatalogTable inputCatalogTable) {
        super(inputCatalogTable);
        if (inputCatalogTable == null) {
            throw new NullPointerException("inputCatalogTable is marked non-null but is null");
        }
        this.initOutputFields(inputCatalogTable, (Map)config.get(MetadataTransformConfig.METADATA_FIELDS));
    }

    private void initOutputFields(CatalogTable inputCatalogTable, Map<String, String> fields) {
        List<String> sourceTableFiledNames = Arrays.asList(inputCatalogTable.getTableSchema().getFieldNames());
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Map.Entry<String, String> field : fields.entrySet()) {
            String srcField = field.getKey();
            if (!MetadataUtil.isMetadataField((String)srcField)) {
                throw TransformCommonError.cannotFindMetadataFieldError(this.getPluginName(), srcField);
            }
            String targetField = field.getValue();
            if (sourceTableFiledNames.contains(targetField)) {
                throw TransformCommonError.metadataMappingFieldExists(this.getPluginName(), srcField);
            }
            fieldNames.add(field.getKey());
        }
        this.fieldNames = fieldNames;
        this.metadataFieldMapping = fields;
    }

    public String getPluginName() {
        return "Metadata";
    }

    @Override
    protected Object[] getOutputFieldValues(SeaTunnelRowAccessor inputRow) {
        Object[] value = new Object[this.fieldNames.size()];
        for (Map.Entry<String, String> mapping : this.metadataFieldMapping.entrySet()) {
            String metadataFieldName = mapping.getKey();
            String mappingFieldName = mapping.getValue();
            int i = this.fieldNames.indexOf(metadataFieldName);
            Object fieldValue = null;
            switch (CommonOptions.fromName((String)metadataFieldName)) {
                case DATABASE: {
                    fieldValue = MetadataUtil.getDatabase((SeaTunnelRowAccessor)inputRow);
                    break;
                }
                case TABLE: {
                    fieldValue = MetadataUtil.getTable((SeaTunnelRowAccessor)inputRow);
                    break;
                }
                case ROW_KIND: {
                    fieldValue = MetadataUtil.getRowKind((SeaTunnelRowAccessor)inputRow);
                    break;
                }
                case DELAY: {
                    fieldValue = MetadataUtil.getDelay((SeaTunnelRowAccessor)inputRow);
                    break;
                }
                case EVENT_TIME: {
                    fieldValue = MetadataUtil.getEventTime((SeaTunnelRowAccessor)inputRow);
                    break;
                }
                case PARTITION: {
                    fieldValue = MetadataUtil.getPartitionStr((SeaTunnelRowAccessor)inputRow);
                    break;
                }
                default: {
                    throw TransformCommonError.cannotFindMetadataFieldError(this.getPluginName(), mappingFieldName);
                }
            }
            value[i] = fieldValue;
        }
        return value;
    }

    @Override
    protected Column[] getOutputColumns() {
        Column[] columns = new Column[this.fieldNames.size()];
        for (Map.Entry<String, String> mapping : this.metadataFieldMapping.entrySet()) {
            PhysicalColumn column;
            String metadataFieldName = mapping.getKey();
            String mappingFieldName = mapping.getValue();
            int i = this.fieldNames.indexOf(metadataFieldName);
            switch (CommonOptions.fromName((String)metadataFieldName)) {
                case DATABASE: 
                case TABLE: 
                case ROW_KIND: 
                case PARTITION: {
                    column = PhysicalColumn.of((String)mappingFieldName, (SeaTunnelDataType)BasicType.STRING_TYPE, (Long)null, null, (boolean)true, null, null);
                    break;
                }
                case DELAY: 
                case EVENT_TIME: {
                    column = PhysicalColumn.of((String)mappingFieldName, (SeaTunnelDataType)BasicType.LONG_TYPE, (Long)null, null, (boolean)true, null, null);
                    break;
                }
                default: {
                    throw TransformCommonError.cannotFindMetadataFieldError(this.getPluginName(), mappingFieldName);
                }
            }
            columns[i] = column;
        }
        return columns;
    }

    @VisibleForTesting
    public void initRowContainerGenerator() {
        this.transformTableSchema();
    }
}

