/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.rename;

import java.io.Serializable;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.shade.com.fasterxml.jackson.annotation.JsonAlias;
import org.apache.seatunnel.transform.rename.ConvertCase;

public class FieldRenameConfig
implements Serializable {
    public static final Option<ConvertCase> CONVERT_CASE = Options.key((String)"convert_case").enumType(ConvertCase.class).noDefaultValue().withDescription("Convert to uppercase or lowercase");
    public static final Option<String> PREFIX = Options.key((String)"prefix").stringType().noDefaultValue().withDescription("Add prefix for field name");
    public static final Option<String> SUFFIX = Options.key((String)"suffix").stringType().noDefaultValue().withDescription("Add suffix for field name");
    public static final Option<List<ReplacementsWithRegex>> REPLACEMENTS_WITH_REGEX = Options.key((String)"replacements_with_regex").listType(ReplacementsWithRegex.class).noDefaultValue().withDescription("The regex of replace fields name to ");
    public static final Option<List<SpecificModify>> SPECIFIC = Options.key((String)"specific").listType(SpecificModify.class).noDefaultValue().withDescription("The specific modify field name");
    @JsonAlias(value={"table_match_regex"})
    private String tableMatchRegex;
    @JsonAlias(value={"is_table_match_regex"})
    private Boolean isTableMatchRegex;
    @JsonAlias(value={"match_tables"})
    private List<String> matchTables;
    @JsonAlias(value={"convert_case"})
    private ConvertCase convertCase;
    @JsonAlias(value={"prefix"})
    private String prefix;
    @JsonAlias(value={"suffix"})
    private String suffix;
    @JsonAlias(value={"replacements_with_regex"})
    private List<ReplacementsWithRegex> replacementsWithRegex;
    @JsonAlias(value={"specific"})
    private List<SpecificModify> specific;

    public static FieldRenameConfig of(ReadonlyConfig config) {
        FieldRenameConfig renameConfig = new FieldRenameConfig();
        renameConfig.setConvertCase((ConvertCase)((Object)config.get(CONVERT_CASE)));
        renameConfig.setPrefix((String)config.get(PREFIX));
        renameConfig.setSuffix((String)config.get(SUFFIX));
        renameConfig.setReplacementsWithRegex((List)config.get(REPLACEMENTS_WITH_REGEX));
        renameConfig.setSpecific((List)config.get(SPECIFIC));
        return renameConfig;
    }

    public String getTableMatchRegex() {
        return this.tableMatchRegex;
    }

    public Boolean getIsTableMatchRegex() {
        return this.isTableMatchRegex;
    }

    public List<String> getMatchTables() {
        return this.matchTables;
    }

    public ConvertCase getConvertCase() {
        return this.convertCase;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public List<ReplacementsWithRegex> getReplacementsWithRegex() {
        return this.replacementsWithRegex;
    }

    public List<SpecificModify> getSpecific() {
        return this.specific;
    }

    public FieldRenameConfig setTableMatchRegex(String tableMatchRegex) {
        this.tableMatchRegex = tableMatchRegex;
        return this;
    }

    public FieldRenameConfig setIsTableMatchRegex(Boolean isTableMatchRegex) {
        this.isTableMatchRegex = isTableMatchRegex;
        return this;
    }

    public FieldRenameConfig setMatchTables(List<String> matchTables) {
        this.matchTables = matchTables;
        return this;
    }

    public FieldRenameConfig setConvertCase(ConvertCase convertCase) {
        this.convertCase = convertCase;
        return this;
    }

    public FieldRenameConfig setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public FieldRenameConfig setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public FieldRenameConfig setReplacementsWithRegex(List<ReplacementsWithRegex> replacementsWithRegex) {
        this.replacementsWithRegex = replacementsWithRegex;
        return this;
    }

    public FieldRenameConfig setSpecific(List<SpecificModify> specific) {
        this.specific = specific;
        return this;
    }

    public static class ReplacementsWithRegex
    implements Serializable {
        @JsonAlias(value={"replace_from"})
        private String replaceFrom;
        @JsonAlias(value={"replace_to"})
        private String replaceTo;
        @JsonAlias(value={"is_regex"})
        private Boolean isRegex;

        public String getReplaceFrom() {
            return this.replaceFrom;
        }

        public String getReplaceTo() {
            return this.replaceTo;
        }

        public Boolean getIsRegex() {
            return this.isRegex;
        }

        public ReplacementsWithRegex setReplaceFrom(String replaceFrom) {
            this.replaceFrom = replaceFrom;
            return this;
        }

        public ReplacementsWithRegex setReplaceTo(String replaceTo) {
            this.replaceTo = replaceTo;
            return this;
        }

        public ReplacementsWithRegex setIsRegex(Boolean isRegex) {
            this.isRegex = isRegex;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplacementsWithRegex)) {
                return false;
            }
            ReplacementsWithRegex other = (ReplacementsWithRegex)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isRegex = this.getIsRegex();
            Boolean other$isRegex = other.getIsRegex();
            if (this$isRegex == null ? other$isRegex != null : !((Object)this$isRegex).equals(other$isRegex)) {
                return false;
            }
            String this$replaceFrom = this.getReplaceFrom();
            String other$replaceFrom = other.getReplaceFrom();
            if (this$replaceFrom == null ? other$replaceFrom != null : !this$replaceFrom.equals(other$replaceFrom)) {
                return false;
            }
            String this$replaceTo = this.getReplaceTo();
            String other$replaceTo = other.getReplaceTo();
            return !(this$replaceTo == null ? other$replaceTo != null : !this$replaceTo.equals(other$replaceTo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReplacementsWithRegex;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isRegex = this.getIsRegex();
            result = result * 59 + ($isRegex == null ? 43 : ((Object)$isRegex).hashCode());
            String $replaceFrom = this.getReplaceFrom();
            result = result * 59 + ($replaceFrom == null ? 43 : $replaceFrom.hashCode());
            String $replaceTo = this.getReplaceTo();
            result = result * 59 + ($replaceTo == null ? 43 : $replaceTo.hashCode());
            return result;
        }

        public String toString() {
            return "FieldRenameConfig.ReplacementsWithRegex(replaceFrom=" + this.getReplaceFrom() + ", replaceTo=" + this.getReplaceTo() + ", isRegex=" + this.getIsRegex() + ")";
        }

        public ReplacementsWithRegex(String replaceFrom, String replaceTo, Boolean isRegex) {
            this.replaceFrom = replaceFrom;
            this.replaceTo = replaceTo;
            this.isRegex = isRegex;
        }

        public ReplacementsWithRegex() {
        }
    }

    public static class SpecificModify
    implements Serializable {
        @JsonAlias(value={"field_name"})
        private String fieldName;
        @JsonAlias(value={"target_name"})
        private String targetName;

        public String getFieldName() {
            return this.fieldName;
        }

        public String getTargetName() {
            return this.targetName;
        }

        public SpecificModify setFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public SpecificModify setTargetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpecificModify)) {
                return false;
            }
            SpecificModify other = (SpecificModify)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            String this$targetName = this.getTargetName();
            String other$targetName = other.getTargetName();
            return !(this$targetName == null ? other$targetName != null : !this$targetName.equals(other$targetName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpecificModify;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            String $targetName = this.getTargetName();
            result = result * 59 + ($targetName == null ? 43 : $targetName.hashCode());
            return result;
        }

        public String toString() {
            return "FieldRenameConfig.SpecificModify(fieldName=" + this.getFieldName() + ", targetName=" + this.getTargetName() + ")";
        }

        public SpecificModify(String fieldName, String targetName) {
            this.fieldName = fieldName;
            this.targetName = targetName;
        }

        public SpecificModify() {
        }
    }
}

