/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.sql.zeta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.transform.exception.TransformException;
import org.apache.seatunnel.transform.sql.SQLEngine;
import org.apache.seatunnel.transform.sql.zeta.ZetaSQLFilter;
import org.apache.seatunnel.transform.sql.zeta.ZetaSQLFunction;
import org.apache.seatunnel.transform.sql.zeta.ZetaSQLType;
import org.apache.seatunnel.transform.sql.zeta.ZetaUDF;

public class ZetaSQLEngine
implements SQLEngine {
    private String inputTableName;
    private SeaTunnelRowType inputRowType;
    private String sql;
    private PlainSelect selectBody;
    private ZetaSQLFunction zetaSQLFunction;
    private ZetaSQLFilter zetaSQLFilter;
    private ZetaSQLType zetaSQLType;

    @Override
    public void init(String inputTableName, SeaTunnelRowType inputRowType, String sql) {
        this.inputTableName = inputTableName;
        this.inputRowType = inputRowType;
        this.sql = sql;
        ArrayList<ZetaUDF> udfList = new ArrayList<ZetaUDF>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ServiceLoader.load(ZetaUDF.class, classLoader).forEach(udfList::add);
        this.zetaSQLType = new ZetaSQLType(inputRowType, udfList);
        this.zetaSQLFunction = new ZetaSQLFunction(inputRowType, this.zetaSQLType, udfList);
        this.zetaSQLFilter = new ZetaSQLFilter(this.zetaSQLFunction);
        this.parseSQL();
    }

    private void parseSQL() {
        try {
            Statement statement = CCJSqlParserUtil.parse(this.sql);
            this.validateSQL(statement);
            this.selectBody = (PlainSelect)((Select)statement).getSelectBody();
        }
        catch (JSQLParserException e) {
            throw new TransformException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("SQL parse failed: %s, cause: %s", this.sql, e.getMessage()));
        }
    }

    private void validateSQL(Statement statement) {
        try {
            if (!(statement instanceof Select)) {
                throw new IllegalArgumentException("Only supported DQL(select) SQL");
            }
            Select select = (Select)statement;
            if (!(select.getSelectBody() instanceof PlainSelect)) {
                throw new IllegalArgumentException("Unsupported SQL syntax");
            }
            PlainSelect selectBody = (PlainSelect)select.getSelectBody();
            FromItem fromItem = selectBody.getFromItem();
            if (fromItem instanceof Table) {
                Table table = (Table)fromItem;
                if (table.getSchemaName() != null) {
                    throw new IllegalArgumentException("Unsupported schema syntax");
                }
                if (table.getAlias() != null) {
                    throw new IllegalArgumentException("Unsupported table alias name syntax");
                }
                String tableName = table.getName();
                if (!this.inputTableName.equalsIgnoreCase(tableName)) {
                    throw new IllegalArgumentException(String.format("Table name: %s not found", tableName));
                }
            } else {
                throw new IllegalArgumentException("Unsupported sub table syntax");
            }
            if (selectBody.getJoins() != null) {
                throw new IllegalArgumentException("Unsupported table join syntax");
            }
            if (selectBody.getOrderByElements() != null) {
                throw new IllegalArgumentException("Unsupported ORDER BY syntax");
            }
            if (selectBody.getGroupBy() != null) {
                throw new IllegalArgumentException("Unsupported GROUP BY syntax");
            }
            if (selectBody.getLimit() != null || selectBody.getOffset() != null) {
                throw new IllegalArgumentException("Unsupported LIMIT,OFFSET syntax");
            }
            for (SelectItem selectItem : selectBody.getSelectItems()) {
                if (!(selectItem instanceof AllColumns)) continue;
                throw new IllegalArgumentException("Unsupported all columns select syntax");
            }
        }
        catch (Exception e) {
            throw new TransformException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("SQL validate failed: %s, cause: %s", this.sql, e.getMessage()));
        }
    }

    @Override
    public SeaTunnelRowType typeMapping(List<String> inputColumnsMapping) {
        List<SelectItem> selectItems = this.selectBody.getSelectItems();
        String[] fieldNames = new String[selectItems.size()];
        SeaTunnelDataType[] seaTunnelDataTypes = new SeaTunnelDataType[selectItems.size()];
        if (inputColumnsMapping != null) {
            for (int i = 0; i < selectItems.size(); ++i) {
                inputColumnsMapping.add(null);
            }
        }
        List inputColumnNames = Arrays.stream(this.inputRowType.getFieldNames()).collect(Collectors.toList());
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            if (!(selectItem instanceof SelectExpressionItem)) continue;
            SelectExpressionItem expressionItem = (SelectExpressionItem)selectItem;
            Expression expression = expressionItem.getExpression();
            fieldNames[i] = expressionItem.getAlias() != null ? expressionItem.getAlias().getName() : (expression instanceof Column ? ((Column)expression).getColumnName() : expression.toString());
            if (inputColumnsMapping != null && expression instanceof Column && inputColumnNames.contains(((Column)expression).getColumnName())) {
                inputColumnsMapping.set(i, ((Column)expression).getColumnName());
            }
            seaTunnelDataTypes[i] = this.zetaSQLType.getExpressionType(expression);
        }
        return new SeaTunnelRowType(fieldNames, seaTunnelDataTypes);
    }

    @Override
    public SeaTunnelRow transformBySQL(SeaTunnelRow inputRow) {
        Object[] inputFields = this.scanTable(inputRow);
        boolean retain = this.zetaSQLFilter.executeFilter(this.selectBody.getWhere(), inputFields);
        if (!retain) {
            return null;
        }
        Object[] outputFields = this.project(inputFields);
        SeaTunnelRow seaTunnelRow = new SeaTunnelRow(outputFields);
        seaTunnelRow.setRowKind(inputRow.getRowKind());
        seaTunnelRow.setTableId(inputRow.getTableId());
        return seaTunnelRow;
    }

    private Object[] scanTable(SeaTunnelRow inputRow) {
        return inputRow.getFields();
    }

    private Object[] project(Object[] inputFields) {
        List<SelectItem> selectItems = this.selectBody.getSelectItems();
        Object[] fields = new Object[selectItems.size()];
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            SelectExpressionItem expressionItem = (SelectExpressionItem)selectItem;
            Expression expression = expressionItem.getExpression();
            fields[i] = this.zetaSQLFunction.computeForValue(expression, inputFields);
        }
        return fields;
    }
}

