/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.source;

import org.apache.seatunnel.api.common.metrics.AbstractMetricsContext;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.api.event.DefaultEventProcessor;
import org.apache.seatunnel.api.event.EventListener;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SourceEvent;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.translation.source.CoordinatedSource;

public class CoordinatedReaderContext
implements SourceReader.Context {
    protected final CoordinatedSource<?, ?, ?> coordinatedSource;
    protected final Boundedness boundedness;
    protected final Integer subtaskId;
    protected final EventListener eventListener;

    public CoordinatedReaderContext(CoordinatedSource<?, ?, ?> coordinatedSource, Boundedness boundedness, String jobId, Integer subtaskId) {
        this.coordinatedSource = coordinatedSource;
        this.boundedness = boundedness;
        this.subtaskId = subtaskId;
        this.eventListener = new DefaultEventProcessor(jobId);
    }

    public int getIndexOfSubtask() {
        return this.subtaskId;
    }

    public Boundedness getBoundedness() {
        return this.boundedness;
    }

    public void signalNoMoreElement() {
        this.coordinatedSource.handleNoMoreElement(this.subtaskId);
    }

    public void sendSplitRequest() {
        this.coordinatedSource.handleSplitRequest(this.subtaskId);
    }

    public void sendSourceEventToEnumerator(SourceEvent sourceEvent) {
        this.coordinatedSource.handleReaderEvent(this.subtaskId, sourceEvent);
    }

    public MetricsContext getMetricsContext() {
        return new AbstractMetricsContext(){};
    }

    public EventListener getEventListener() {
        return this.eventListener;
    }
}

