/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.source;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.seatunnel.api.common.metrics.AbstractMetricsContext;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.api.event.DefaultEventProcessor;
import org.apache.seatunnel.api.event.EventListener;
import org.apache.seatunnel.api.source.SourceEvent;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.translation.source.ParallelSource;

public class ParallelEnumeratorContext<SplitT extends SourceSplit>
implements SourceSplitEnumerator.Context<SplitT> {
    protected final ParallelSource<?, SplitT, ?> parallelSource;
    protected final Integer parallelism;
    protected final Integer subtaskId;
    protected final EventListener eventListener;
    protected volatile boolean running = false;

    public ParallelEnumeratorContext(ParallelSource<?, SplitT, ?> parallelSource, int parallelism, String jobId, int subtaskId) {
        this.parallelSource = parallelSource;
        this.parallelism = parallelism;
        this.subtaskId = subtaskId;
        this.eventListener = new DefaultEventProcessor(jobId);
    }

    public int currentParallelism() {
        return this.parallelism;
    }

    public Set<Integer> registeredReaders() {
        return this.running ? Collections.singleton(this.subtaskId) : Collections.emptySet();
    }

    public void register() {
        this.running = true;
    }

    public void assignSplit(int subtaskId, List<SplitT> splits) {
        if (this.subtaskId == subtaskId) {
            this.parallelSource.addSplits(splits);
        }
    }

    public void signalNoMoreSplits(int subtaskId) {
        if (this.subtaskId == subtaskId) {
            this.parallelSource.handleNoMoreSplits();
        }
    }

    public void sendEventToSourceReader(int subtaskId, SourceEvent event) {
        throw new UnsupportedOperationException("Flink ParallelSource don't support sending SourceEvent. Please implement the `SupportCoordinate` marker interface on the SeaTunnel source.");
    }

    public MetricsContext getMetricsContext() {
        return new AbstractMetricsContext(){};
    }

    public EventListener getEventListener() {
        return this.eventListener;
    }
}

