/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.source;

import org.apache.seatunnel.api.common.metrics.AbstractMetricsContext;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.api.event.DefaultEventProcessor;
import org.apache.seatunnel.api.event.EventListener;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SourceEvent;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.translation.source.ParallelSource;

public class ParallelReaderContext
implements SourceReader.Context {
    protected final ParallelSource<?, ?, ?> parallelSource;
    protected final Boundedness boundedness;
    protected final Integer subtaskId;
    protected final EventListener eventListener;

    public ParallelReaderContext(ParallelSource<?, ?, ?> parallelSource, Boundedness boundedness, String jobId, Integer subtaskId) {
        this.parallelSource = parallelSource;
        this.boundedness = boundedness;
        this.subtaskId = subtaskId;
        this.eventListener = new DefaultEventProcessor(jobId);
    }

    public int getIndexOfSubtask() {
        return this.subtaskId;
    }

    public Boundedness getBoundedness() {
        return this.boundedness;
    }

    public void signalNoMoreElement() {
        this.parallelSource.handleNoMoreElement();
    }

    public void sendSplitRequest() {
        this.parallelSource.handleSplitRequest(this.subtaskId);
    }

    public void sendSourceEventToEnumerator(SourceEvent sourceEvent) {
        throw new UnsupportedOperationException("Flink ParallelSource don't support sending SourceEvent. Please implement the `SupportCoordinate` marker interface on the SeaTunnel source.");
    }

    public MetricsContext getMetricsContext() {
        return new AbstractMetricsContext(){};
    }

    public EventListener getEventListener() {
        return this.eventListener;
    }
}

