/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.serialization;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Some;

public abstract class RowConverter<T>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RowConverter.class);
    protected final SeaTunnelDataType<?> dataType;

    public RowConverter(SeaTunnelDataType<?> dataType) {
        this.dataType = dataType;
    }

    public void validate(SeaTunnelRow seaTunnelRow) throws IOException {
        if (!(this.dataType instanceof SeaTunnelRowType)) {
            throw new UnsupportedOperationException(String.format("The data type don't support validation: %s. ", this.dataType.getClass().getSimpleName()));
        }
        SeaTunnelDataType[] fieldTypes = ((SeaTunnelRowType)this.dataType).getFieldTypes();
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < fieldTypes.length; ++i) {
            SeaTunnelDataType fieldType;
            Object field = seaTunnelRow.getField(i);
            if (this.validate(field, fieldType = fieldTypes[i])) continue;
            errors.add(String.format("The SQL type '%s' don't support '%s', the class of the expected data type is '%s'.", fieldType.getSqlType(), field.getClass(), fieldType.getTypeClass()));
        }
        if (!errors.isEmpty()) {
            throw new UnsupportedOperationException(String.join((CharSequence)",", errors));
        }
    }

    protected boolean validate(Object field, SeaTunnelDataType<?> dataType) {
        if (field == null || dataType.getSqlType() == SqlType.NULL) {
            return true;
        }
        SqlType sqlType = dataType.getSqlType();
        switch (sqlType) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_TZ: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case DECIMAL: 
            case BYTES: {
                boolean isEq;
                boolean bl = isEq = dataType.getTypeClass() == field.getClass();
                if (!isEq) {
                    log.error(String.format("dateType.getTypeClass is %s, but field.getClass is %s", dataType.getTypeClass(), field.getClass()));
                }
                return isEq;
            }
            case ARRAY: {
                if (!(field instanceof Object[])) {
                    return false;
                }
                ArrayType arrayType = (ArrayType)dataType;
                Object[] arrayField = (Object[])field;
                if (arrayField.length == 0) {
                    return true;
                }
                return this.validate(arrayField[0], arrayType.getElementType());
            }
            case MAP: {
                Object value;
                if (!(field instanceof Map)) {
                    log.error(String.format("field type is %s, not instanceof java.util.Map", field.getClass()));
                    return false;
                }
                MapType mapType = (MapType)dataType;
                Map mapField = (Map)field;
                if (mapField.isEmpty()) {
                    return true;
                }
                Map.Entry entry = (Map.Entry)mapField.entrySet().stream().findFirst().get();
                Object key = entry.getKey();
                if (key instanceof Some) {
                    key = ((Some)key).get();
                }
                if ((value = entry.getValue()) instanceof Some) {
                    value = ((Some)value).get();
                }
                return this.validate(key, mapType.getKeyType()) && this.validate(value, mapType.getValueType());
            }
            case ROW: {
                if (!(field instanceof SeaTunnelRow)) {
                    return false;
                }
                SeaTunnelDataType[] fieldTypes = ((SeaTunnelRowType)dataType).getFieldTypes();
                SeaTunnelRow seaTunnelRow = (SeaTunnelRow)field;
                for (int i = 0; i < fieldTypes.length; ++i) {
                    if (this.validate(seaTunnelRow.getField(i), fieldTypes[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public abstract T convert(SeaTunnelRow var1) throws IOException;

    public abstract SeaTunnelRow reconvert(T var1) throws IOException;
}

