/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.source;

import java.util.List;
import java.util.Set;
import org.apache.seatunnel.api.common.metrics.AbstractMetricsContext;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.api.event.DefaultEventProcessor;
import org.apache.seatunnel.api.event.EventListener;
import org.apache.seatunnel.api.source.SourceEvent;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.translation.source.CoordinatedSource;

public class CoordinatedEnumeratorContext<SplitT extends SourceSplit>
implements SourceSplitEnumerator.Context<SplitT> {
    protected final CoordinatedSource<?, SplitT, ?> coordinatedSource;
    protected final EventListener eventListener;

    public CoordinatedEnumeratorContext(CoordinatedSource<?, SplitT, ?> coordinatedSource, String jobId) {
        this.coordinatedSource = coordinatedSource;
        this.eventListener = new DefaultEventProcessor(jobId);
    }

    public int currentParallelism() {
        return this.coordinatedSource.currentReaderCount();
    }

    public Set<Integer> registeredReaders() {
        return this.coordinatedSource.registeredReaders();
    }

    public void assignSplit(int subtaskId, List<SplitT> splits) {
        this.coordinatedSource.addSplits(subtaskId, splits);
    }

    public void signalNoMoreSplits(int subtaskId) {
        this.coordinatedSource.handleNoMoreSplits(subtaskId);
    }

    public void sendEventToSourceReader(int subtaskId, SourceEvent event) {
        this.coordinatedSource.handleEnumeratorEvent(subtaskId, event);
    }

    public MetricsContext getMetricsContext() {
        return new AbstractMetricsContext(){};
    }

    public EventListener getEventListener() {
        return this.eventListener;
    }
}

