/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.flink.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.translation.flink.sink.CommitWrapper;

public class CommitWrapperSerializer<T>
implements SimpleVersionedSerializer<CommitWrapper<T>> {
    private final Serializer<T> serializer;

    public CommitWrapperSerializer(Serializer<T> serializer) {
        this.serializer = serializer;
    }

    public int getVersion() {
        return 0;
    }

    public byte[] serialize(CommitWrapper<T> commitWrapper) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(baos);){
                byte[] serialize = this.serializer.serialize(commitWrapper.getCommit());
                out.writeInt(serialize.length);
                out.write(serialize);
                out.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public CommitWrapper<T> deserialize(int version, byte[] serialized) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            CommitWrapper<Object> commitWrapper;
            try (DataInputStream in = new DataInputStream(bais);){
                int size = in.readInt();
                byte[] stateBytes = new byte[size];
                in.read(stateBytes);
                Object commitT = this.serializer.deserialize(stateBytes);
                commitWrapper = new CommitWrapper<Object>(commitT);
            }
            return commitWrapper;
        }
    }
}

