/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.flink.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.translation.flink.sink.FlinkWriterState;

public class FlinkWriterStateSerializer<T>
implements SimpleVersionedSerializer<FlinkWriterState<T>> {
    private final Serializer<T> serializer;

    public FlinkWriterStateSerializer(Serializer<T> serializer) {
        this.serializer = serializer;
    }

    public int getVersion() {
        return 0;
    }

    public byte[] serialize(FlinkWriterState<T> state) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(baos);){
                out.writeLong(state.getCheckpointId());
                byte[] serialize = this.serializer.serialize(state.getState());
                out.writeInt(serialize.length);
                out.write(serialize);
                out.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public FlinkWriterState<T> deserialize(int version, byte[] serialized) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            FlinkWriterState<Object> flinkWriterState;
            try (DataInputStream in = new DataInputStream(bais);){
                long checkpointId = in.readLong();
                int size = in.readInt();
                byte[] stateBytes = new byte[size];
                in.read(stateBytes);
                Object stateT = this.serializer.deserialize(stateBytes);
                flinkWriterState = new FlinkWriterState<Object>(checkpointId, stateT);
            }
            return flinkWriterState;
        }
    }
}

