/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.flink.source;

import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.seatunnel.api.common.metrics.Counter;
import org.apache.seatunnel.api.common.metrics.Meter;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.core.starter.flowcontrol.FlowControlGate;
import org.apache.seatunnel.core.starter.flowcontrol.FlowControlStrategy;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkRowCollector
implements Collector<SeaTunnelRow> {
    private static final Logger log = LoggerFactory.getLogger(FlinkRowCollector.class);
    private ReaderOutput<SeaTunnelRow> readerOutput;
    private final FlowControlGate flowControlGate;
    private final Counter sourceReadCount;
    private final Counter sourceReadBytes;
    private final Meter sourceReadQPS;
    private boolean emptyThisPollNext = true;

    public FlinkRowCollector(Config envConfig, MetricsContext metricsContext) {
        this.flowControlGate = FlowControlGate.create((FlowControlStrategy)FlowControlStrategy.fromConfig((Config)envConfig));
        this.sourceReadCount = metricsContext.counter("SourceReceivedCount");
        this.sourceReadBytes = metricsContext.counter("SourceReceivedBytes");
        this.sourceReadQPS = metricsContext.meter("SourceReceivedQPS");
    }

    public void collect(SeaTunnelRow record) {
        this.flowControlGate.audit(record);
        try {
            this.readerOutput.collect((Object)record);
            this.sourceReadCount.inc();
            this.sourceReadBytes.inc((long)record.getBytesSize());
            this.sourceReadQPS.markEvent();
            this.emptyThisPollNext = false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object getCheckpointLock() {
        return this;
    }

    public boolean isEmptyThisPollNext() {
        return this.emptyThisPollNext;
    }

    public void resetEmptyThisPollNext() {
        this.emptyThisPollNext = true;
    }

    public FlinkRowCollector withReaderOutput(ReaderOutput<SeaTunnelRow> readerOutput) {
        this.readerOutput = readerOutput;
        this.emptyThisPollNext = true;
        return this;
    }
}

