/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.flink.source;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.translation.flink.source.SplitWrapper;

public class SplitWrapperSerializer<SplitT extends SourceSplit>
implements SimpleVersionedSerializer<SplitWrapper<SplitT>> {
    private final Serializer<SplitT> serializer;

    public SplitWrapperSerializer(Serializer<SplitT> serializer) {
        this.serializer = serializer;
    }

    public int getVersion() {
        return 0;
    }

    public byte[] serialize(SplitWrapper<SplitT> obj) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(baos);){
                byte[] serialize = this.serializer.serialize(obj.getSourceSplit());
                out.writeInt(serialize.length);
                out.write(serialize);
                out.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public SplitWrapper<SplitT> deserialize(int version, byte[] serialized) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            SplitWrapper<SourceSplit> splitWrapper;
            try (DataInputStream in = new DataInputStream(bais);){
                int size = in.readInt();
                byte[] stateBytes = new byte[size];
                in.read(stateBytes);
                SourceSplit split = (SourceSplit)this.serializer.deserialize(stateBytes);
                splitWrapper = new SplitWrapper<SourceSplit>(split);
            }
            return splitWrapper;
        }
    }
}

