/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.flink.metric;

import java.time.Duration;
import java.time.LocalDateTime;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.StringFormatUtils;

public final class FlinkJobMetricsSummary {
    private final JobExecutionResult jobExecutionResult;
    private final LocalDateTime jobStartTime;
    private final LocalDateTime jobEndTime;

    FlinkJobMetricsSummary(JobExecutionResult jobExecutionResult, LocalDateTime jobStartTime, LocalDateTime jobEndTime) {
        this.jobExecutionResult = jobExecutionResult;
        this.jobStartTime = jobStartTime;
        this.jobEndTime = jobEndTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return StringFormatUtils.formatTable((Object[])new Object[]{"Job Statistic Information", "Start Time", DateTimeUtils.toString((LocalDateTime)this.jobStartTime, (DateTimeUtils.Formatter)DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS), "End Time", DateTimeUtils.toString((LocalDateTime)this.jobEndTime, (DateTimeUtils.Formatter)DateTimeUtils.Formatter.YYYY_MM_DD_HH_MM_SS), "Total Time(s)", Duration.between(this.jobStartTime, this.jobEndTime).getSeconds(), "Total Read Count", this.jobExecutionResult.getAllAccumulatorResults().get("SourceReceivedCount"), "Total Write Count", this.jobExecutionResult.getAllAccumulatorResults().get("SinkWriteCount"), "Total Read Bytes", this.jobExecutionResult.getAllAccumulatorResults().get("SourceReceivedBytes"), "Total Write Bytes", this.jobExecutionResult.getAllAccumulatorResults().get("SinkWriteBytes")});
    }

    public static class Builder {
        private JobExecutionResult jobExecutionResult;
        private long jobStartTime;
        private long jobEndTime;

        private Builder() {
        }

        public Builder jobExecutionResult(JobExecutionResult jobExecutionResult) {
            this.jobExecutionResult = jobExecutionResult;
            return this;
        }

        public Builder jobStartTime(long jobStartTime) {
            this.jobStartTime = jobStartTime;
            return this;
        }

        public Builder jobEndTime(long jobEndTime) {
            this.jobEndTime = jobEndTime;
            return this;
        }

        public FlinkJobMetricsSummary build() {
            return new FlinkJobMetricsSummary(this.jobExecutionResult, DateTimeUtils.parse((long)this.jobStartTime), DateTimeUtils.parse((long)this.jobEndTime));
        }
    }
}

