/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.flink.source;

import java.io.Serializable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.translation.flink.serialization.FlinkSimpleVersionedSerializer;
import org.apache.seatunnel.translation.flink.source.FlinkSourceEnumerator;
import org.apache.seatunnel.translation.flink.source.FlinkSourceReader;
import org.apache.seatunnel.translation.flink.source.FlinkSourceReaderContext;
import org.apache.seatunnel.translation.flink.source.FlinkSourceSplitEnumeratorContext;
import org.apache.seatunnel.translation.flink.source.SplitWrapper;
import org.apache.seatunnel.translation.flink.source.SplitWrapperSerializer;

public class FlinkSource<SplitT extends SourceSplit, EnumStateT extends Serializable>
implements Source<SeaTunnelRow, SplitWrapper<SplitT>, EnumStateT>,
ResultTypeQueryable<SeaTunnelRow> {
    private final SeaTunnelSource<SeaTunnelRow, SplitT, EnumStateT> source;
    private final Config envConfig;

    public FlinkSource(SeaTunnelSource<SeaTunnelRow, SplitT, EnumStateT> source, Config envConfig) {
        this.source = source;
        this.envConfig = envConfig;
    }

    public Boundedness getBoundedness() {
        org.apache.seatunnel.api.source.Boundedness boundedness = this.source.getBoundedness();
        return boundedness == org.apache.seatunnel.api.source.Boundedness.BOUNDED ? Boundedness.BOUNDED : Boundedness.CONTINUOUS_UNBOUNDED;
    }

    public SourceReader<SeaTunnelRow, SplitWrapper<SplitT>> createReader(SourceReaderContext readerContext) throws Exception {
        FlinkSourceReaderContext context = new FlinkSourceReaderContext(readerContext, this.source);
        org.apache.seatunnel.api.source.SourceReader reader = this.source.createReader((SourceReader.Context)context);
        return new FlinkSourceReader(reader, context, this.envConfig);
    }

    public SplitEnumerator<SplitWrapper<SplitT>, EnumStateT> createEnumerator(SplitEnumeratorContext<SplitWrapper<SplitT>> enumContext) throws Exception {
        FlinkSourceSplitEnumeratorContext<SplitT> context = new FlinkSourceSplitEnumeratorContext<SplitT>(enumContext);
        SourceSplitEnumerator enumerator = this.source.createEnumerator(context);
        return new FlinkSourceEnumerator(enumerator, enumContext);
    }

    public SplitEnumerator<SplitWrapper<SplitT>, EnumStateT> restoreEnumerator(SplitEnumeratorContext<SplitWrapper<SplitT>> enumContext, EnumStateT checkpoint) throws Exception {
        FlinkSourceSplitEnumeratorContext<SplitT> context = new FlinkSourceSplitEnumeratorContext<SplitT>(enumContext);
        SourceSplitEnumerator enumerator = this.source.restoreEnumerator(context, checkpoint);
        return new FlinkSourceEnumerator(enumerator, enumContext);
    }

    public SimpleVersionedSerializer<SplitWrapper<SplitT>> getSplitSerializer() {
        return new SplitWrapperSerializer(this.source.getSplitSerializer());
    }

    public SimpleVersionedSerializer<EnumStateT> getEnumeratorCheckpointSerializer() {
        Serializer enumeratorStateSerializer = this.source.getEnumeratorStateSerializer();
        return new FlinkSimpleVersionedSerializer(enumeratorStateSerializer);
    }

    public TypeInformation<SeaTunnelRow> getProducedType() {
        return TypeInformation.of(SeaTunnelRow.class);
    }
}

