/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.flink.metric;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.seatunnel.api.common.metrics.Counter;
import org.apache.seatunnel.api.common.metrics.Meter;
import org.apache.seatunnel.api.common.metrics.Metric;
import org.apache.seatunnel.api.common.metrics.MetricsContext;
import org.apache.seatunnel.translation.flink.metric.FlinkCounter;
import org.apache.seatunnel.translation.flink.metric.FlinkMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkMetricContext
implements MetricsContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlinkMetricContext.class);
    private final Map<String, Metric> metrics = new ConcurrentHashMap<String, Metric>();
    private final StreamingRuntimeContext runtimeContext;

    public FlinkMetricContext(StreamingRuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    public Counter counter(String name) {
        if (this.metrics.containsKey(name)) {
            return (Counter)this.metrics.get(name);
        }
        return this.counter(name, new FlinkCounter(name, this.runtimeContext.getLongCounter(name)));
    }

    public <C extends Counter> C counter(String name, C counter) {
        this.addMetric(name, (Metric)counter);
        return counter;
    }

    public Meter meter(String name) {
        if (this.metrics.containsKey(name)) {
            return (Meter)this.metrics.get(name);
        }
        return this.meter(name, new FlinkMeter(name, this.runtimeContext.getMetricGroup().meter(name, (org.apache.flink.metrics.Meter)new MeterView(5))));
    }

    public <M extends Meter> M meter(String name, M meter) {
        this.addMetric(name, (Metric)meter);
        return meter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMetric(String name, Metric metric) {
        if (metric == null) {
            LOGGER.warn("Ignoring attempted add of a metric due to being null for name {}.", (Object)name);
        } else {
            FlinkMetricContext flinkMetricContext = this;
            synchronized (flinkMetricContext) {
                Metric prior = this.metrics.put(name, metric);
                if (prior != null) {
                    this.metrics.put(name, prior);
                    LOGGER.warn("Name collision: MetricsContext already contains a Metric with the name '" + name + "'. Metric will not be reported.");
                }
            }
        }
    }
}

