/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.flink.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.seatunnel.api.sink.SinkCommitter;
import org.apache.seatunnel.translation.flink.sink.CommitWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkCommitter<CommT>
implements Committer<CommitWrapper<CommT>> {
    private static final Logger log = LoggerFactory.getLogger(FlinkCommitter.class);
    private final SinkCommitter<CommT> sinkCommitter;

    FlinkCommitter(SinkCommitter<CommT> sinkCommitter) {
        this.sinkCommitter = sinkCommitter;
    }

    public List<CommitWrapper<CommT>> commit(List<CommitWrapper<CommT>> committables) throws IOException {
        List reCommittable = this.sinkCommitter.commit(committables.stream().map(CommitWrapper::getCommit).collect(Collectors.toList()));
        if (reCommittable != null && !reCommittable.isEmpty()) {
            log.warn("this version not support re-commit when use flink engine");
        }
        return new ArrayList<CommitWrapper<CommT>>();
    }

    public void close() throws Exception {
    }
}

