/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.spark.source.partition.micro;

import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SupportCoordinate;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.translation.spark.source.reader.SeaTunnelInputPartitionReader;
import org.apache.seatunnel.translation.spark.source.reader.micro.CoordinatedMicroBatchPartitionReader;
import org.apache.seatunnel.translation.spark.source.reader.micro.ParallelMicroBatchPartitionReader;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.reader.InputPartitionReader;

public class MicroBatchPartition
implements InputPartition<InternalRow> {
    protected final SeaTunnelSource<SeaTunnelRow, ?, ?> source;
    protected final Integer parallelism;
    protected final Integer subtaskId;
    protected final Integer checkpointId;
    protected final Integer checkpointInterval;
    protected final String checkpointPath;
    protected final String hdfsRoot;
    protected final String hdfsUser;

    public MicroBatchPartition(SeaTunnelSource<SeaTunnelRow, ?, ?> source, Integer parallelism, Integer subtaskId, Integer checkpointId, Integer checkpointInterval, String checkpointPath, String hdfsRoot, String hdfsUser) {
        this.source = source;
        this.parallelism = parallelism;
        this.subtaskId = subtaskId;
        this.checkpointId = checkpointId;
        this.checkpointInterval = checkpointInterval;
        this.checkpointPath = checkpointPath;
        this.hdfsRoot = hdfsRoot;
        this.hdfsUser = hdfsUser;
    }

    public InputPartitionReader<InternalRow> createPartitionReader() {
        ParallelMicroBatchPartitionReader partitionReader = this.source instanceof SupportCoordinate ? new CoordinatedMicroBatchPartitionReader(this.source, this.parallelism, this.subtaskId, this.checkpointId, this.checkpointInterval, this.checkpointPath, this.hdfsRoot, this.hdfsUser) : new ParallelMicroBatchPartitionReader(this.source, this.parallelism, this.subtaskId, this.checkpointId, this.checkpointInterval, this.checkpointPath, this.hdfsRoot, this.hdfsUser);
        return new SeaTunnelInputPartitionReader(partitionReader);
    }
}

